/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.ApplicationCapability;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="<div class=\"x-lifecycle-container\"><x-lifecycle class=\"oie\"></x-lifecycle></div> Indicates which Express Configuration capabilities the app supports and has enabled")
@JsonPropertyOrder(value={"enabledCapabilities", "supportedCapabilities"})
public class ApplicationExpressConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ENABLED_CAPABILITIES = "enabledCapabilities";
    private List<ApplicationCapability> enabledCapabilities = null;
    public static final String JSON_PROPERTY_SUPPORTED_CAPABILITIES = "supportedCapabilities";
    private List<ApplicationCapability> supportedCapabilities = null;

    public ApplicationExpressConfiguration enabledCapabilities(List<ApplicationCapability> enabledCapabilities) {
        this.enabledCapabilities = enabledCapabilities;
        return this;
    }

    public ApplicationExpressConfiguration addenabledCapabilitiesItem(ApplicationCapability enabledCapabilitiesItem) {
        if (this.enabledCapabilities == null) {
            this.enabledCapabilities = new ArrayList<ApplicationCapability>();
        }
        this.enabledCapabilities.add(enabledCapabilitiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"SSO\"]", value="Capabilities currently enabled for the app")
    @JsonProperty(value="enabledCapabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ApplicationCapability> getEnabledCapabilities() {
        return this.enabledCapabilities;
    }

    @JsonProperty(value="enabledCapabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabledCapabilities(List<ApplicationCapability> enabledCapabilities) {
        this.enabledCapabilities = enabledCapabilities;
    }

    public ApplicationExpressConfiguration supportedCapabilities(List<ApplicationCapability> supportedCapabilities) {
        this.supportedCapabilities = supportedCapabilities;
        return this;
    }

    public ApplicationExpressConfiguration addsupportedCapabilitiesItem(ApplicationCapability supportedCapabilitiesItem) {
        if (this.supportedCapabilities == null) {
            this.supportedCapabilities = new ArrayList<ApplicationCapability>();
        }
        this.supportedCapabilities.add(supportedCapabilitiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"SSO\",\"PROVISIONING\",\"UNIVERSAL_LOGOUT\"]", value="Capabilities supported by the app")
    @JsonProperty(value="supportedCapabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ApplicationCapability> getSupportedCapabilities() {
        return this.supportedCapabilities;
    }

    @JsonProperty(value="supportedCapabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupportedCapabilities(List<ApplicationCapability> supportedCapabilities) {
        this.supportedCapabilities = supportedCapabilities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationExpressConfiguration applicationExpressConfiguration = (ApplicationExpressConfiguration)o;
        return Objects.equals(this.enabledCapabilities, applicationExpressConfiguration.enabledCapabilities) && Objects.equals(this.supportedCapabilities, applicationExpressConfiguration.supportedCapabilities);
    }

    public int hashCode() {
        return Objects.hash(this.enabledCapabilities, this.supportedCapabilities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationExpressConfiguration {\n");
        sb.append("    enabledCapabilities: ").append(this.toIndentedString(this.enabledCapabilities)).append("\n");
        sb.append("    supportedCapabilities: ").append(this.toIndentedString(this.supportedCapabilities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

