/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.okta.sdk.resource.model.ActiveDirectoryGroupScope;
import com.okta.sdk.resource.model.ActiveDirectoryGroupType;
import com.okta.sdk.resource.model.AppConfig;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"distinguishedName", "groupScope", "groupType", "samAccountName"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=AppConfigActiveDirectory.class)
public class AppConfigActiveDirectory
extends AppConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DISTINGUISHED_NAME = "distinguishedName";
    private String distinguishedName;
    public static final String JSON_PROPERTY_GROUP_SCOPE = "groupScope";
    private ActiveDirectoryGroupScope groupScope;
    public static final String JSON_PROPERTY_GROUP_TYPE = "groupType";
    private ActiveDirectoryGroupType groupType;
    public static final String JSON_PROPERTY_SAM_ACCOUNT_NAME = "samAccountName";
    private String samAccountName;

    public AppConfigActiveDirectory distinguishedName(String distinguishedName) {
        this.distinguishedName = distinguishedName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The distinguished name of the group in Active Directory")
    @JsonProperty(value="distinguishedName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDistinguishedName() {
        return this.distinguishedName;
    }

    @JsonProperty(value="distinguishedName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDistinguishedName(String distinguishedName) {
        this.distinguishedName = distinguishedName;
    }

    public AppConfigActiveDirectory groupScope(ActiveDirectoryGroupScope groupScope) {
        this.groupScope = groupScope;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="groupScope")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ActiveDirectoryGroupScope getGroupScope() {
        return this.groupScope;
    }

    @JsonProperty(value="groupScope")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGroupScope(ActiveDirectoryGroupScope groupScope) {
        this.groupScope = groupScope;
    }

    public AppConfigActiveDirectory groupType(ActiveDirectoryGroupType groupType) {
        this.groupType = groupType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="groupType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ActiveDirectoryGroupType getGroupType() {
        return this.groupType;
    }

    @JsonProperty(value="groupType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGroupType(ActiveDirectoryGroupType groupType) {
        this.groupType = groupType;
    }

    public AppConfigActiveDirectory samAccountName(String samAccountName) {
        this.samAccountName = samAccountName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The SAM account name of the group in Active Directory")
    @JsonProperty(value="samAccountName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSamAccountName() {
        return this.samAccountName;
    }

    @JsonProperty(value="samAccountName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSamAccountName(String samAccountName) {
        this.samAccountName = samAccountName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppConfigActiveDirectory appConfigActiveDirectory = (AppConfigActiveDirectory)o;
        return Objects.equals(this.distinguishedName, appConfigActiveDirectory.distinguishedName) && Objects.equals((Object)this.groupScope, (Object)appConfigActiveDirectory.groupScope) && Objects.equals((Object)this.groupType, (Object)appConfigActiveDirectory.groupType) && Objects.equals(this.samAccountName, appConfigActiveDirectory.samAccountName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.distinguishedName, this.groupScope, this.groupType, this.samAccountName, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppConfigActiveDirectory {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    distinguishedName: ").append(this.toIndentedString(this.distinguishedName)).append("\n");
        sb.append("    groupScope: ").append(this.toIndentedString((Object)this.groupScope)).append("\n");
        sb.append("    groupType: ").append(this.toIndentedString((Object)this.groupType)).append("\n");
        sb.append("    samAccountName: ").append(this.toIndentedString(this.samAccountName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

