/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.ApiTokenNetwork;
import com.okta.sdk.resource.model.LinksSelf;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="An API token for an Okta User. This token is NOT scoped any further and can be used for any API the user has permissions to call.")
@JsonPropertyOrder(value={"clientName", "created", "expiresAt", "id", "lastUpdated", "name", "network", "tokenWindow", "userId", "_link"})
public class ApiToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CLIENT_NAME = "clientName";
    private String clientName;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_NETWORK = "network";
    private ApiTokenNetwork network;
    public static final String JSON_PROPERTY_TOKEN_WINDOW = "tokenWindow";
    private String tokenWindow;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;
    public static final String JSON_PROPERTY_LINK = "_link";
    private LinksSelf link;

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="clientName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientName() {
        return this.clientName;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public ApiToken name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public ApiToken network(ApiTokenNetwork network) {
        this.network = network;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="network")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApiTokenNetwork getNetwork() {
        return this.network;
    }

    @JsonProperty(value="network")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetwork(ApiTokenNetwork network) {
        this.network = network;
    }

    public ApiToken tokenWindow(String tokenWindow) {
        this.tokenWindow = tokenWindow;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A time duration specified as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).")
    @JsonProperty(value="tokenWindow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTokenWindow() {
        return this.tokenWindow;
    }

    @JsonProperty(value="tokenWindow")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenWindow(String tokenWindow) {
        this.tokenWindow = tokenWindow;
    }

    public ApiToken userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ApiToken link(LinksSelf link) {
        this.link = link;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_link")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LinksSelf getLink() {
        return this.link;
    }

    @JsonProperty(value="_link")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLink(LinksSelf link) {
        this.link = link;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiToken apiToken = (ApiToken)o;
        return Objects.equals(this.clientName, apiToken.clientName) && Objects.equals(this.created, apiToken.created) && Objects.equals(this.expiresAt, apiToken.expiresAt) && Objects.equals(this.id, apiToken.id) && Objects.equals(this.lastUpdated, apiToken.lastUpdated) && Objects.equals(this.name, apiToken.name) && Objects.equals(this.network, apiToken.network) && Objects.equals(this.tokenWindow, apiToken.tokenWindow) && Objects.equals(this.userId, apiToken.userId) && Objects.equals(this.link, apiToken.link);
    }

    public int hashCode() {
        return Objects.hash(this.clientName, this.created, this.expiresAt, this.id, this.lastUpdated, this.name, this.network, this.tokenWindow, this.userId, this.link);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiToken {\n");
        sb.append("    clientName: ").append(this.toIndentedString(this.clientName)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    tokenWindow: ").append(this.toIndentedString(this.tokenWindow)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    link: ").append(this.toIndentedString(this.link)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

