/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="An EC signing key")
@JsonPropertyOrder(value={"crv", "kty", "x", "y", "kid", "status", "alg", "use"})
public class AgentJsonWebKeyECRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CRV = "crv";
    private CrvEnum crv;
    public static final String JSON_PROPERTY_KTY = "kty";
    private KtyEnum kty;
    public static final String JSON_PROPERTY_X = "x";
    private String x;
    public static final String JSON_PROPERTY_Y = "y";
    private String y;
    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status = StatusEnum.ACTIVE;
    public static final String JSON_PROPERTY_ALG = "alg";
    private String alg;
    public static final String JSON_PROPERTY_USE = "use";
    private UseEnum use;

    public AgentJsonWebKeyECRequest crv(CrvEnum crv) {
        this.crv = crv;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="P-256", value="The cryptographic curve that's used for the key pair")
    @JsonProperty(value="crv")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CrvEnum getCrv() {
        return this.crv;
    }

    @JsonProperty(value="crv")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCrv(CrvEnum crv) {
        this.crv = crv;
    }

    public AgentJsonWebKeyECRequest kty(KtyEnum kty) {
        this.kty = kty;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="EC", required=true, value="Cryptographic algorithm family for the certificate's key pair")
    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public KtyEnum getKty() {
        return this.kty;
    }

    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKty(KtyEnum kty) {
        this.kty = kty;
    }

    public AgentJsonWebKeyECRequest x(String x) {
        this.x = x;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The public x coordinate for the elliptic curve point")
    @JsonProperty(value="x")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getX() {
        return this.x;
    }

    @JsonProperty(value="x")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setX(String x) {
        this.x = x;
    }

    public AgentJsonWebKeyECRequest y(String y) {
        this.y = y;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The public y coordinate for the elliptic curve point")
    @JsonProperty(value="y")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getY() {
        return this.y;
    }

    @JsonProperty(value="y")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setY(String y) {
        this.y = y;
    }

    public AgentJsonWebKeyECRequest kid(String kid) {
        this.kid = kid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="SIMcCQNY3uwXoW3y0vf6VxiBb5n9pf8L2fK8d-FIbm4", value="Unique identifier of the JSON Web Key in the AI agent's JSON Web Key Set (JWKS)")
    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKid() {
        return this.kid;
    }

    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKid(String kid) {
        this.kid = kid;
    }

    public AgentJsonWebKeyECRequest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ACTIVE", value="Status of the AI agent JSON Web Key")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AgentJsonWebKeyECRequest alg(String alg) {
        this.alg = alg;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="RS256", value="Algorithm that's used in the JSON Web Key")
    @JsonProperty(value="alg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAlg() {
        return this.alg;
    }

    @JsonProperty(value="alg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAlg(String alg) {
        this.alg = alg;
    }

    public AgentJsonWebKeyECRequest use(UseEnum use) {
        this.use = use;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="sig", value="Acceptable use of the JSON Web Key  You can only use signing keys for AI agents, so the value of `use` is always `sig`.")
    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UseEnum getUse() {
        return this.use;
    }

    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUse(UseEnum use) {
        this.use = use;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentJsonWebKeyECRequest agentJsonWebKeyECRequest = (AgentJsonWebKeyECRequest)o;
        return Objects.equals((Object)this.crv, (Object)agentJsonWebKeyECRequest.crv) && Objects.equals((Object)this.kty, (Object)agentJsonWebKeyECRequest.kty) && Objects.equals(this.x, agentJsonWebKeyECRequest.x) && Objects.equals(this.y, agentJsonWebKeyECRequest.y) && Objects.equals(this.kid, agentJsonWebKeyECRequest.kid) && Objects.equals((Object)this.status, (Object)agentJsonWebKeyECRequest.status) && Objects.equals(this.alg, agentJsonWebKeyECRequest.alg) && Objects.equals((Object)this.use, (Object)agentJsonWebKeyECRequest.use);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.crv, this.kty, this.x, this.y, this.kid, this.status, this.alg, this.use});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgentJsonWebKeyECRequest {\n");
        sb.append("    crv: ").append(this.toIndentedString((Object)this.crv)).append("\n");
        sb.append("    kty: ").append(this.toIndentedString((Object)this.kty)).append("\n");
        sb.append("    x: ").append(this.toIndentedString(this.x)).append("\n");
        sb.append("    y: ").append(this.toIndentedString(this.y)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    alg: ").append(this.toIndentedString(this.alg)).append("\n");
        sb.append("    use: ").append(this.toIndentedString((Object)this.use)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),
        INACTIVE(String.valueOf("INACTIVE")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum CrvEnum {
        P_256(String.valueOf("P-256")),
        P_384(String.valueOf("P-384")),
        P_521(String.valueOf("P-521")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private CrvEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CrvEnum fromValue(String value) {
            for (CrvEnum b : CrvEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum KtyEnum {
        EC(String.valueOf("EC")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private KtyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KtyEnum fromValue(String value) {
            for (KtyEnum b : KtyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum UseEnum {
        SIG(String.valueOf("sig")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private UseEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UseEnum fromValue(String value) {
            for (UseEnum b : UseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

