/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.ResourceSet;
import com.okta.sdk.resource.model.ResourceSetResource;
import com.okta.sdk.resource.model.ResourceSetResourcePatchRequest;
import com.okta.sdk.resource.model.ResourceSetResourcePostRequest;
import com.okta.sdk.resource.model.ResourceSetResourcePutRequest;
import com.okta.sdk.resource.model.ResourceSetResources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class RoleCResourceSetResourceApi {
    private ApiClient apiClient;

    public RoleCResourceSetResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleCResourceSetResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ResourceSetResource addResourceSetResource(String resourceSetIdOrLabel, ResourceSetResourcePostRequest instance) throws ApiException {
        return this.addResourceSetResource(resourceSetIdOrLabel, instance, Collections.emptyMap());
    }

    public ResourceSetResource addResourceSetResource(String resourceSetIdOrLabel, ResourceSetResourcePostRequest instance, Map<String, String> additionalHeaders) throws ApiException {
        ResourceSetResourcePostRequest localVarPostBody = instance;
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetIdOrLabel' when calling addResourceSetResource");
        }
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling addResourceSetResource");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/resources".replaceAll("\\{resourceSetIdOrLabel\\}", this.apiClient.escapeString(resourceSetIdOrLabel.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSetResource> localVarReturnType = new TypeReference<ResourceSetResource>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceSet addResourceSetResources(String resourceSetIdOrLabel, ResourceSetResourcePatchRequest instance) throws ApiException {
        return this.addResourceSetResources(resourceSetIdOrLabel, instance, Collections.emptyMap());
    }

    public ResourceSet addResourceSetResources(String resourceSetIdOrLabel, ResourceSetResourcePatchRequest instance, Map<String, String> additionalHeaders) throws ApiException {
        ResourceSetResourcePatchRequest localVarPostBody = instance;
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetIdOrLabel' when calling addResourceSetResources");
        }
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling addResourceSetResources");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/resources".replaceAll("\\{resourceSetIdOrLabel\\}", this.apiClient.escapeString(resourceSetIdOrLabel.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSet> localVarReturnType = new TypeReference<ResourceSet>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteResourceSetResource(String resourceSetIdOrLabel, String resourceId) throws ApiException {
        this.deleteResourceSetResource(resourceSetIdOrLabel, resourceId, Collections.emptyMap());
    }

    public void deleteResourceSetResource(String resourceSetIdOrLabel, String resourceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetIdOrLabel' when calling deleteResourceSetResource");
        }
        if (resourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceId' when calling deleteResourceSetResource");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/resources/{resourceId}".replaceAll("\\{resourceSetIdOrLabel\\}", this.apiClient.escapeString(resourceSetIdOrLabel.toString())).replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public ResourceSetResource getResourceSetResource(String resourceSetIdOrLabel, String resourceId) throws ApiException {
        return this.getResourceSetResource(resourceSetIdOrLabel, resourceId, Collections.emptyMap());
    }

    public ResourceSetResource getResourceSetResource(String resourceSetIdOrLabel, String resourceId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetIdOrLabel' when calling getResourceSetResource");
        }
        if (resourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceId' when calling getResourceSetResource");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/resources/{resourceId}".replaceAll("\\{resourceSetIdOrLabel\\}", this.apiClient.escapeString(resourceSetIdOrLabel.toString())).replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSetResource> localVarReturnType = new TypeReference<ResourceSetResource>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceSetResources listResourceSetResources(String resourceSetIdOrLabel, String after, Integer limit) throws ApiException {
        return this.listResourceSetResources(resourceSetIdOrLabel, after, limit, Collections.emptyMap());
    }

    public ResourceSetResources listResourceSetResources(String resourceSetIdOrLabel, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetIdOrLabel' when calling listResourceSetResources");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/resources".replaceAll("\\{resourceSetIdOrLabel\\}", this.apiClient.escapeString(resourceSetIdOrLabel.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSetResources> localVarReturnType = new TypeReference<ResourceSetResources>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceSetResource replaceResourceSetResource(String resourceSetIdOrLabel, String resourceId, ResourceSetResourcePutRequest resourceSetResourcePutRequest) throws ApiException {
        return this.replaceResourceSetResource(resourceSetIdOrLabel, resourceId, resourceSetResourcePutRequest, Collections.emptyMap());
    }

    public ResourceSetResource replaceResourceSetResource(String resourceSetIdOrLabel, String resourceId, ResourceSetResourcePutRequest resourceSetResourcePutRequest, Map<String, String> additionalHeaders) throws ApiException {
        ResourceSetResourcePutRequest localVarPostBody = resourceSetResourcePutRequest;
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetIdOrLabel' when calling replaceResourceSetResource");
        }
        if (resourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceId' when calling replaceResourceSetResource");
        }
        if (resourceSetResourcePutRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetResourcePutRequest' when calling replaceResourceSetResource");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}/resources/{resourceId}".replaceAll("\\{resourceSetIdOrLabel\\}", this.apiClient.escapeString(resourceSetIdOrLabel.toString())).replaceAll("\\{resourceId\\}", this.apiClient.escapeString(resourceId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSetResource> localVarReturnType = new TypeReference<ResourceSetResource>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

