/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.PagedIterable;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.AssignRoleToClient200Response;
import com.okta.sdk.resource.model.AssignRoleToClientRequest;
import com.okta.sdk.resource.model.ListRolesForClient200ResponseInner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class RoleAssignmentClientApi {
    private ApiClient apiClient;

    public RoleAssignmentClientApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleAssignmentClientApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AssignRoleToClient200Response assignRoleToClient(String clientId, AssignRoleToClientRequest assignRoleToClientRequest) throws ApiException {
        return this.assignRoleToClient(clientId, assignRoleToClientRequest, Collections.emptyMap());
    }

    public AssignRoleToClient200Response assignRoleToClient(String clientId, AssignRoleToClientRequest assignRoleToClientRequest, Map<String, String> additionalHeaders) throws ApiException {
        AssignRoleToClientRequest localVarPostBody = assignRoleToClientRequest;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling assignRoleToClient");
        }
        if (assignRoleToClientRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'assignRoleToClientRequest' when calling assignRoleToClient");
        }
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles".replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AssignRoleToClient200Response> localVarReturnType = new TypeReference<AssignRoleToClient200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteRoleFromClient(String clientId, String roleAssignmentId) throws ApiException {
        this.deleteRoleFromClient(clientId, roleAssignmentId, Collections.emptyMap());
    }

    public void deleteRoleFromClient(String clientId, String roleAssignmentId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling deleteRoleFromClient");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling deleteRoleFromClient");
        }
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}".replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<ListRolesForClient200ResponseInner> listRolesForClient(String clientId) throws ApiException {
        return this.listRolesForClient(clientId, Collections.emptyMap());
    }

    public List<ListRolesForClient200ResponseInner> listRolesForClient(String clientId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling listRolesForClient");
        }
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles".replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<ListRolesForClient200ResponseInner>> localVarReturnType = new TypeReference<List<ListRolesForClient200ResponseInner>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<ListRolesForClient200ResponseInner> listRolesForClientPaged(String clientId) {
        return this.listRolesForClientPaged(clientId, Collections.emptyMap());
    }

    public Iterable<ListRolesForClient200ResponseInner> listRolesForClientPaged(String clientId, Map<String, String> additionalHeaders) {
        return new PagedIterable<ListRolesForClient200ResponseInner>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/oauth2/v1/clients/{clientId}/roles".replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString()));
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<ListRolesForClient200ResponseInner>> localVarReturnType = new TypeReference<List<ListRolesForClient200ResponseInner>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<ListRolesForClient200ResponseInner>> localVarReturnType = new TypeReference<List<ListRolesForClient200ResponseInner>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public AssignRoleToClient200Response retrieveClientRole(String clientId, String roleAssignmentId) throws ApiException {
        return this.retrieveClientRole(clientId, roleAssignmentId, Collections.emptyMap());
    }

    public AssignRoleToClient200Response retrieveClientRole(String clientId, String roleAssignmentId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling retrieveClientRole");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling retrieveClientRole");
        }
        String localVarPath = "/oauth2/v1/clients/{clientId}/roles/{roleAssignmentId}".replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AssignRoleToClient200Response> localVarReturnType = new TypeReference<AssignRoleToClient200Response>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

