/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.SmsTemplateType;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"created", "id", "lastUpdated", "name", "template", "translations", "type"})
public class SmsTemplate
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TEMPLATE = "template";
    private String template;
    public static final String JSON_PROPERTY_TRANSLATIONS = "translations";
    private Object translations;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SmsTemplateType type;

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public SmsTemplate name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable name of the Template")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public SmsTemplate template(String template) {
        this.template = template;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Text of the Template, including any [macros](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Template/)")
    @JsonProperty(value="template")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTemplate() {
        return this.template;
    }

    @JsonProperty(value="template")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTemplate(String template) {
        this.template = template;
    }

    public SmsTemplate translations(Object translations) {
        this.translations = translations;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="- Template translations are optionally provided when you want to localize the SMS messages. Translations are provided as an object that contains `key:value` pairs: the language and the translated Template text. The key portion is a two-letter country code that conforms to [ISO 639-1](https://www.loc.gov/standards/iso639-2/php/code_list.php). The value is the translated SMS Template. - Just like with regular SMS Templates, the length of the SMS message can't exceed 160 characters. ")
    @JsonProperty(value="translations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getTranslations() {
        return this.translations;
    }

    @JsonProperty(value="translations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTranslations(Object translations) {
        this.translations = translations;
    }

    public SmsTemplate type(SmsTemplateType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SmsTemplateType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(SmsTemplateType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmsTemplate smsTemplate = (SmsTemplate)o;
        return Objects.equals(this.created, smsTemplate.created) && Objects.equals(this.id, smsTemplate.id) && Objects.equals(this.lastUpdated, smsTemplate.lastUpdated) && Objects.equals(this.name, smsTemplate.name) && Objects.equals(this.template, smsTemplate.template) && Objects.equals(this.translations, smsTemplate.translations) && Objects.equals((Object)this.type, (Object)smsTemplate.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.created, this.id, this.lastUpdated, this.name, this.template, this.translations, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SmsTemplate {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    translations: ").append(this.toIndentedString(this.translations)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

