/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.MtlsCredentials;
import com.okta.sdk.resource.model.MtlsEndpoints;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Protocol settings for the [MTLS Protocol](https://tools.ietf.org/html/rfc5246#section-7.4.4)")
@JsonPropertyOrder(value={"credentials", "endpoints", "type"})
public class ProtocolMtls
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private MtlsCredentials credentials;
    public static final String JSON_PROPERTY_ENDPOINTS = "endpoints";
    private MtlsEndpoints endpoints;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public ProtocolMtls credentials(MtlsCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MtlsCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(MtlsCredentials credentials) {
        this.credentials = credentials;
    }

    public ProtocolMtls endpoints(MtlsEndpoints endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="endpoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MtlsEndpoints getEndpoints() {
        return this.endpoints;
    }

    @JsonProperty(value="endpoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndpoints(MtlsEndpoints endpoints) {
        this.endpoints = endpoints;
    }

    public ProtocolMtls type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Mutual TLS")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtocolMtls protocolMtls = (ProtocolMtls)o;
        return Objects.equals(this.credentials, protocolMtls.credentials) && Objects.equals(this.endpoints, protocolMtls.endpoints) && Objects.equals((Object)this.type, (Object)protocolMtls.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.credentials, this.endpoints, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProtocolMtls {\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    endpoints: ").append(this.toIndentedString(this.endpoints)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        MTLS(String.valueOf("MTLS")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

