/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.okta.sdk.resource.model.AuthenticationMethodChain;
import com.okta.sdk.resource.model.VerificationMethod;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"chains", "reauthenticateIn"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=AuthenticationMethodChainMethod.class)
public class AuthenticationMethodChainMethod
extends VerificationMethod
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CHAINS = "chains";
    private List<AuthenticationMethodChain> chains = null;
    public static final String JSON_PROPERTY_REAUTHENTICATE_IN = "reauthenticateIn";
    private String reauthenticateIn;

    public AuthenticationMethodChainMethod chains(List<AuthenticationMethodChain> chains) {
        this.chains = chains;
        return this;
    }

    public AuthenticationMethodChainMethod addchainsItem(AuthenticationMethodChain chainsItem) {
        if (this.chains == null) {
            this.chains = new ArrayList<AuthenticationMethodChain>();
        }
        this.chains.add(chainsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Authentication method chains. Only supports 5 items in the array. Each chain can support maximum 3 steps.")
    @JsonProperty(value="chains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AuthenticationMethodChain> getChains() {
        return this.chains;
    }

    @JsonProperty(value="chains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChains(List<AuthenticationMethodChain> chains) {
        this.chains = chains;
    }

    public AuthenticationMethodChainMethod reauthenticateIn(String reauthenticateIn) {
        this.reauthenticateIn = reauthenticateIn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies how often the user should be prompted for authentication using duration format for the time period.  For example, `PT2H30M` for two and a half hours. Don't set this parameter if you're setting the `reauthenticateIn` parameter in `chains`.")
    @JsonProperty(value="reauthenticateIn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReauthenticateIn() {
        return this.reauthenticateIn;
    }

    @JsonProperty(value="reauthenticateIn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReauthenticateIn(String reauthenticateIn) {
        this.reauthenticateIn = reauthenticateIn;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationMethodChainMethod authenticationMethodChainMethod = (AuthenticationMethodChainMethod)o;
        return Objects.equals(this.chains, authenticationMethodChainMethod.chains) && Objects.equals(this.reauthenticateIn, authenticationMethodChainMethod.reauthenticateIn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.chains, this.reauthenticateIn, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticationMethodChainMethod {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    chains: ").append(this.toIndentedString(this.chains)).append("\n");
        sb.append("    reauthenticateIn: ").append(this.toIndentedString(this.reauthenticateIn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

