/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.PagedIterable;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.Application;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class ApplicationApi {
    private ApiClient apiClient;

    public ApplicationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void activateApplication(String appId) throws ApiException {
        this.activateApplication(appId, Collections.emptyMap());
    }

    public void activateApplication(String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling activateApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/lifecycle/activate".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Application createApplication(Application application, Boolean activate, String oktaAccessGatewayAgent) throws ApiException {
        return this.createApplication(application, activate, oktaAccessGatewayAgent, Collections.emptyMap());
    }

    public Application createApplication(Application application, Boolean activate, String oktaAccessGatewayAgent, Map<String, String> additionalHeaders) throws ApiException {
        Application localVarPostBody = application;
        if (application == null) {
            throw new ApiException(400, "Missing the required parameter 'application' when calling createApplication");
        }
        String localVarPath = "/api/v1/apps";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activate", activate));
        if (oktaAccessGatewayAgent != null) {
            localVarHeaderParams.put("OktaAccessGateway-Agent", this.apiClient.parameterToString(oktaAccessGatewayAgent));
        }
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Application> localVarReturnType = new TypeReference<Application>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deactivateApplication(String appId) throws ApiException {
        this.deactivateApplication(appId, Collections.emptyMap());
    }

    public void deactivateApplication(String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deactivateApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/lifecycle/deactivate".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteApplication(String appId) throws ApiException {
        this.deleteApplication(appId, Collections.emptyMap());
    }

    public void deleteApplication(String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Application getApplication(String appId, String expand) throws ApiException {
        return this.getApplication(appId, expand, Collections.emptyMap());
    }

    public Application getApplication(String appId, String expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Application> localVarReturnType = new TypeReference<Application>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Application> listApplications(String q, String after, Boolean useOptimization, Integer limit, String filter, String expand, Boolean includeNonDeleted) throws ApiException {
        return this.listApplications(q, after, useOptimization, limit, filter, expand, includeNonDeleted, Collections.emptyMap());
    }

    public List<Application> listApplications(String q, String after, Boolean useOptimization, Integer limit, String filter, String expand, Boolean includeNonDeleted, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/apps";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("useOptimization", useOptimization));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("includeNonDeleted", includeNonDeleted));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<Application>> localVarReturnType = new TypeReference<List<Application>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<Application> listApplicationsPaged(String q, String after, Boolean useOptimization, Integer limit, String filter, String expand, Boolean includeNonDeleted) {
        return this.listApplicationsPaged(q, after, useOptimization, limit, filter, expand, includeNonDeleted, Collections.emptyMap());
    }

    public Iterable<Application> listApplicationsPaged(String q, String after, Boolean useOptimization, Integer limit, String filter, String expand, Boolean includeNonDeleted, Map<String, String> additionalHeaders) {
        return new PagedIterable<Application>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/apps";
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("useOptimization", useOptimization));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", filter));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("includeNonDeleted", includeNonDeleted));
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<Application>> localVarReturnType = new TypeReference<List<Application>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<Application>> localVarReturnType = new TypeReference<List<Application>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public Application replaceApplication(String appId, Application application) throws ApiException {
        return this.replaceApplication(appId, application, Collections.emptyMap());
    }

    public Application replaceApplication(String appId, Application application, Map<String, String> additionalHeaders) throws ApiException {
        Application localVarPostBody = application;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling replaceApplication");
        }
        if (application == null) {
            throw new ApiException(400, "Missing the required parameter 'application' when calling replaceApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Application> localVarReturnType = new TypeReference<Application>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

