/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Security Events Provider settings")
@JsonPropertyOrder(value={"issuer", "jwks_url", "well_known_url"})
public class SecurityEventsProviderSettingsResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer;
    public static final String JSON_PROPERTY_JWKS_URL = "jwks_url";
    private String jwksUrl;
    public static final String JSON_PROPERTY_WELL_KNOWN_URL = "well_known_url";
    private JsonNullable<String> wellKnownUrl = JsonNullable.undefined();

    public SecurityEventsProviderSettingsResponse issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="example.okta.com", value="Issuer URL")
    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuer() {
        return this.issuer;
    }

    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public SecurityEventsProviderSettingsResponse jwksUrl(String jwksUrl) {
        this.jwksUrl = jwksUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://example.okta.com/oauth2/v1/keys", value="The public URL where the JWKS public key is uploaded")
    @JsonProperty(value="jwks_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getJwksUrl() {
        return this.jwksUrl;
    }

    @JsonProperty(value="jwks_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJwksUrl(String jwksUrl) {
        this.jwksUrl = jwksUrl;
    }

    public SecurityEventsProviderSettingsResponse wellKnownUrl(String wellKnownUrl) {
        this.wellKnownUrl = JsonNullable.of((Object)wellKnownUrl);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://example.okta.com/.well-known/ssf-configuration", value="The well-known URL of the Security Events Provider (the SSF transmitter)")
    @JsonIgnore
    public String getWellKnownUrl() {
        return (String)this.wellKnownUrl.orElse(null);
    }

    @JsonProperty(value="well_known_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getWellKnownUrl_JsonNullable() {
        return this.wellKnownUrl;
    }

    @JsonProperty(value="well_known_url")
    public void setWellKnownUrl_JsonNullable(JsonNullable<String> wellKnownUrl) {
        this.wellKnownUrl = wellKnownUrl;
    }

    public void setWellKnownUrl(String wellKnownUrl) {
        this.wellKnownUrl = JsonNullable.of((Object)wellKnownUrl);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityEventsProviderSettingsResponse securityEventsProviderSettingsResponse = (SecurityEventsProviderSettingsResponse)o;
        return Objects.equals(this.issuer, securityEventsProviderSettingsResponse.issuer) && Objects.equals(this.jwksUrl, securityEventsProviderSettingsResponse.jwksUrl) && SecurityEventsProviderSettingsResponse.equalsNullable(this.wellKnownUrl, securityEventsProviderSettingsResponse.wellKnownUrl);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.issuer, this.jwksUrl, SecurityEventsProviderSettingsResponse.hashCodeNullable(this.wellKnownUrl));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityEventsProviderSettingsResponse {\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    jwksUrl: ").append(this.toIndentedString(this.jwksUrl)).append("\n");
        sb.append("    wellKnownUrl: ").append(this.toIndentedString(this.wellKnownUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

