/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.okta.sdk.resource.model.Application;
import com.okta.sdk.resource.model.ApplicationCredentials;
import com.okta.sdk.resource.model.SamlApplicationSettings;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"credentials", "name", "settings"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="signOnMode", visible=true, defaultImpl=SamlApplication.class)
public class SamlApplication
extends Application
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private ApplicationCredentials credentials;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private SamlApplicationSettings settings;

    public SamlApplication credentials(ApplicationCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(ApplicationCredentials credentials) {
        this.credentials = credentials;
    }

    @Nullable
    @ApiModelProperty(value="A unique key is generated for the custom app instance when you use SAML_2_0 `signOnMode`.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public SamlApplication settings(SamlApplicationSettings settings) {
        this.settings = settings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SamlApplicationSettings getSettings() {
        return this.settings;
    }

    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSettings(SamlApplicationSettings settings) {
        this.settings = settings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamlApplication samlApplication = (SamlApplication)o;
        return Objects.equals(this.credentials, samlApplication.credentials) && Objects.equals(this.name, samlApplication.name) && Objects.equals(this.settings, samlApplication.settings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.credentials, this.name, this.settings, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlApplication {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

