/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.IdentityProviderApplicationUserLinks;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"created", "externalId", "id", "lastUpdated", "profile", "_embedded", "_links"})
public class IdentityProviderApplicationUser
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_EXTERNAL_ID = "externalId";
    private String externalId;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, Object> profile = null;
    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private Map<String, Object> embedded = null;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private IdentityProviderApplicationUserLinks links;

    @Nullable
    @ApiModelProperty(example="2016-01-03T18:15:47Z", value="Timestamp when the object was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Nullable
    @ApiModelProperty(example="saml.jackson@example.com", value="Unique IdP-specific identifier for the User")
    @JsonProperty(value="externalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalId() {
        return this.externalId;
    }

    @Nullable
    @ApiModelProperty(value="Unique key of the User")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(example="2016-01-03T18:15:47Z", value="Timestamp when the object was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public IdentityProviderApplicationUser profile(Map<String, Object> profile) {
        this.profile = profile;
        return this;
    }

    public IdentityProviderApplicationUser putprofileItem(String key, Object profileItem) {
        if (this.profile == null) {
            this.profile = new HashMap<String, Object>();
        }
        this.profile.put(key, profileItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"lastName\":\"Jackson\",\"subjectNameQualifier\":\"example.com\",\"subjectSpNameQualifier\":\"urn:federation:example\",\"authnContextClassRef\":null,\"subjectNameId\":\"saml.jackson@example.com\",\"subjectConfirmationAddress\":null,\"displayName\":\"Saml Jackson\",\"mobilePhone\":\"+1-415-555-5141\",\"email\":\"saml.jackson@example.com\",\"subjectNameFormat\":\"urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress\",\"firstName\":\"Saml\",\"subjectSpProvidedId\":null,\"subjectConfirmationMethod\":null}", value="IdP-specific profile for the User.   Identity Provider User profiles are IdP-specific but may be customized by the Profile Editor in the Admin Console.  > **Note:** Okta variable names have reserved characters that may conflict with the name of an IdP assertion attribute. You can use the **External name** to define the attribute name as defined in an IdP assertion such as a SAML attribute name.")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Map<String, Object> profile) {
        this.profile = profile;
    }

    @Nullable
    @ApiModelProperty(value="Embedded resources related to the IdP User")
    @JsonProperty(value="_embedded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getEmbedded() {
        return this.embedded;
    }

    public IdentityProviderApplicationUser links(IdentityProviderApplicationUserLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IdentityProviderApplicationUserLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(IdentityProviderApplicationUserLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityProviderApplicationUser identityProviderApplicationUser = (IdentityProviderApplicationUser)o;
        return Objects.equals(this.created, identityProviderApplicationUser.created) && Objects.equals(this.externalId, identityProviderApplicationUser.externalId) && Objects.equals(this.id, identityProviderApplicationUser.id) && Objects.equals(this.lastUpdated, identityProviderApplicationUser.lastUpdated) && Objects.equals(this.profile, identityProviderApplicationUser.profile) && Objects.equals(this.embedded, identityProviderApplicationUser.embedded) && Objects.equals(this.links, identityProviderApplicationUser.links);
    }

    public int hashCode() {
        return Objects.hash(this.created, this.externalId, this.id, this.lastUpdated, this.profile, this.embedded, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityProviderApplicationUser {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    embedded: ").append(this.toIndentedString(this.embedded)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

