/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Certificate metadata for the domain")
@JsonPropertyOrder(value={"expiration", "fingerprint", "subject"})
public class DomainCertificateMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_EXPIRATION = "expiration";
    private String expiration;
    public static final String JSON_PROPERTY_FINGERPRINT = "fingerprint";
    private String fingerprint;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject;

    public DomainCertificateMetadata expiration(String expiration) {
        this.expiration = expiration;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2021-05-11T05:13:05.000Z", value="Certificate expiration")
    @JsonProperty(value="expiration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpiration() {
        return this.expiration;
    }

    @JsonProperty(value="expiration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }

    public DomainCertificateMetadata fingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="73:68:82:7B:83:2E:48:29:A5:5E:E8:40:41:80:B3:AA:03:C4:42:43:05:73:45:BC:AA:47:00:23:A3:70:E5:C4", value="Certificate fingerprint")
    @JsonProperty(value="fingerprint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFingerprint() {
        return this.fingerprint;
    }

    @JsonProperty(value="fingerprint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public DomainCertificateMetadata subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CN=login.example.com", value="Certificate subject")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainCertificateMetadata domainCertificateMetadata = (DomainCertificateMetadata)o;
        return Objects.equals(this.expiration, domainCertificateMetadata.expiration) && Objects.equals(this.fingerprint, domainCertificateMetadata.fingerprint) && Objects.equals(this.subject, domainCertificateMetadata.subject);
    }

    public int hashCode() {
        return Objects.hash(this.expiration, this.fingerprint, this.subject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DomainCertificateMetadata {\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    fingerprint: ").append(this.toIndentedString(this.fingerprint)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

