/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.okta.sdk.resource.model.BaseContextUserLinks;
import com.okta.sdk.resource.model.BaseContextUserProfile;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Identifies the Okta user that the token was generated to authenticate and provides details of their Okta user profile")
@JsonPropertyOrder(value={"id", "passwordChanged", "profile", "_links"})
@JsonTypeName(value="BaseContext_user")
public class BaseContextUser
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_PASSWORD_CHANGED = "passwordChanged";
    private OffsetDateTime passwordChanged;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private BaseContextUserProfile profile;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private BaseContextUserLinks links;

    public BaseContextUser id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00uq8tMo3zV0OfJON0g3", value="The unique identifier for the user")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public BaseContextUser passwordChanged(OffsetDateTime passwordChanged) {
        this.passwordChanged = passwordChanged;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2018-09-11T23:19:12Z", value="The timestamp when the user's password was last updated")
    @JsonProperty(value="passwordChanged")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getPasswordChanged() {
        return this.passwordChanged;
    }

    @JsonProperty(value="passwordChanged")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPasswordChanged(OffsetDateTime passwordChanged) {
        this.passwordChanged = passwordChanged;
    }

    public BaseContextUser profile(BaseContextUserProfile profile) {
        this.profile = profile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BaseContextUserProfile getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(BaseContextUserProfile profile) {
        this.profile = profile;
    }

    public BaseContextUser links(BaseContextUserLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BaseContextUserLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(BaseContextUserLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseContextUser baseContextUser = (BaseContextUser)o;
        return Objects.equals(this.id, baseContextUser.id) && Objects.equals(this.passwordChanged, baseContextUser.passwordChanged) && Objects.equals(this.profile, baseContextUser.profile) && Objects.equals(this.links, baseContextUser.links);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.passwordChanged, this.profile, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseContextUser {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    passwordChanged: ").append(this.toIndentedString(this.passwordChanged)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

