/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="When an error object is returned, it causes Okta to return an OAuth 2.0 error to the requester of the token. In the error response, the value of `error` is `server_error`, and the value of `error_description` is the string that you supplied in the `errorSummary` property of the `error` object that you returned.")
@JsonPropertyOrder(value={"errorSummary"})
@JsonTypeName(value="TokenHookResponse_error")
public class TokenHookResponseError
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ERROR_SUMMARY = "errorSummary";
    private String errorSummary;

    public TokenHookResponseError errorSummary(String errorSummary) {
        this.errorSummary = errorSummary;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable summary of the error. If the error object doesn't include the `errorSummary` property defined, the following common default message is returned to the end user: `The callback service returned an error`.")
    @JsonProperty(value="errorSummary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorSummary() {
        return this.errorSummary;
    }

    @JsonProperty(value="errorSummary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorSummary(String errorSummary) {
        this.errorSummary = errorSummary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenHookResponseError tokenHookResponseError = (TokenHookResponseError)o;
        return Objects.equals(this.errorSummary, tokenHookResponseError.errorSummary);
    }

    public int hashCode() {
        return Objects.hash(this.errorSummary);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenHookResponseError {\n");
        sb.append("    errorSummary: ").append(this.toIndentedString(this.errorSummary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

