/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.okta.sdk.resource.model.JsonWebKeyEC;
import com.okta.sdk.resource.model.JsonWebKeyRsa;
import com.okta.sdk.resource.model.JsonWebKeyStatus;
import com.okta.sdk.resource.model.JsonWebKeyType;
import com.okta.sdk.resource.model.JsonWebKeyUse;
import com.okta.sdk.resource.model.SigningAlgorithm;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A [JSON Web Key (JWK)](https://tools.ietf.org/html/rfc7517) is a JSON representation of a cryptographic key. Okta can use these keys to verify the signature of a JWT when provided for the `private_key_jwt` client authentication method or for a signed authorize request object. Okta supports both RSA and Elliptic Curve (EC) keys.")
@JsonPropertyOrder(value={"alg", "kid", "kty", "status", "use"})
@JsonTypeName(value="schemas-JsonWebKey")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="kty", visible=true, defaultImpl=SchemasJsonWebKey.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=JsonWebKeyEC.class, name="EC"), @JsonSubTypes.Type(value=JsonWebKeyRsa.class, name="RSA")})
public class SchemasJsonWebKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ALG = "alg";
    private SigningAlgorithm alg;
    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;
    public static final String JSON_PROPERTY_KTY = "kty";
    protected JsonWebKeyType kty;
    public static final String JSON_PROPERTY_STATUS = "status";
    private JsonWebKeyStatus status;
    public static final String JSON_PROPERTY_USE = "use";
    private JsonWebKeyUse use;

    public SchemasJsonWebKey alg(SigningAlgorithm alg) {
        this.alg = alg;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="alg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SigningAlgorithm getAlg() {
        return this.alg;
    }

    @JsonProperty(value="alg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAlg(SigningAlgorithm alg) {
        this.alg = alg;
    }

    public SchemasJsonWebKey kid(String kid) {
        this.kid = kid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier of the key")
    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKid() {
        return this.kid;
    }

    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKid(String kid) {
        this.kid = kid;
    }

    public SchemasJsonWebKey kty(JsonWebKeyType kty) {
        this.kty = kty;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonWebKeyType getKty() {
        return this.kty;
    }

    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKty(JsonWebKeyType kty) {
        this.kty = kty;
    }

    public SchemasJsonWebKey status(JsonWebKeyStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonWebKeyStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(JsonWebKeyStatus status) {
        this.status = status;
    }

    public SchemasJsonWebKey use(JsonWebKeyUse use) {
        this.use = use;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonWebKeyUse getUse() {
        return this.use;
    }

    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUse(JsonWebKeyUse use) {
        this.use = use;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemasJsonWebKey schemasJsonWebKey = (SchemasJsonWebKey)o;
        return Objects.equals((Object)this.alg, (Object)schemasJsonWebKey.alg) && Objects.equals(this.kid, schemasJsonWebKey.kid) && Objects.equals((Object)this.kty, (Object)schemasJsonWebKey.kty) && Objects.equals((Object)this.status, (Object)schemasJsonWebKey.status) && Objects.equals((Object)this.use, (Object)schemasJsonWebKey.use);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.alg, this.kid, this.kty, this.status, this.use});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SchemasJsonWebKey {\n");
        sb.append("    alg: ").append(this.toIndentedString((Object)this.alg)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    kty: ").append(this.toIndentedString((Object)this.kty)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    use: ").append(this.toIndentedString((Object)this.use)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

