/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.IdentitySourceSessionStatus;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"created", "id", "identitySourceId", "importType", "lastUpdated", "status"})
public class IdentitySourceSession
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_IDENTITY_SOURCE_ID = "identitySourceId";
    private String identitySourceId;
    public static final String JSON_PROPERTY_IMPORT_TYPE = "importType";
    private String importType;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_STATUS = "status";
    private IdentitySourceSessionStatus status;

    @Nullable
    @ApiModelProperty(value="The timestamp when the Identity Source Session was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the Identity Source Session")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the custom Identity Source for which the session is created")
    @JsonProperty(value="identitySourceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentitySourceId() {
        return this.identitySourceId;
    }

    @Nullable
    @ApiModelProperty(value="The type of import.  All imports are `INCREMENTAL` imports.")
    @JsonProperty(value="importType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImportType() {
        return this.importType;
    }

    @Nullable
    @ApiModelProperty(value="The timestamp when the Identity Source Session was created")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public IdentitySourceSession status(IdentitySourceSessionStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IdentitySourceSessionStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(IdentitySourceSessionStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentitySourceSession identitySourceSession = (IdentitySourceSession)o;
        return Objects.equals(this.created, identitySourceSession.created) && Objects.equals(this.id, identitySourceSession.id) && Objects.equals(this.identitySourceId, identitySourceSession.identitySourceId) && Objects.equals(this.importType, identitySourceSession.importType) && Objects.equals(this.lastUpdated, identitySourceSession.lastUpdated) && Objects.equals((Object)this.status, (Object)identitySourceSession.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.created, this.id, this.identitySourceId, this.importType, this.lastUpdated, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentitySourceSession {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    identitySourceId: ").append(this.toIndentedString(this.identitySourceId)).append("\n");
        sb.append("    importType: ").append(this.toIndentedString(this.importType)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

