/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Enrollment Initialization Response")
@JsonPropertyOrder(value={"authenticatorEnrollmentIds", "fulfillmentProvider", "userId"})
public class EnrollmentActivationResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_IDS = "authenticatorEnrollmentIds";
    private List<String> authenticatorEnrollmentIds = null;
    public static final String JSON_PROPERTY_FULFILLMENT_PROVIDER = "fulfillmentProvider";
    private FulfillmentProviderEnum fulfillmentProvider;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;

    public EnrollmentActivationResponse authenticatorEnrollmentIds(List<String> authenticatorEnrollmentIds) {
        this.authenticatorEnrollmentIds = authenticatorEnrollmentIds;
        return this;
    }

    public EnrollmentActivationResponse addauthenticatorEnrollmentIdsItem(String authenticatorEnrollmentIdsItem) {
        if (this.authenticatorEnrollmentIds == null) {
            this.authenticatorEnrollmentIds = new ArrayList<String>();
        }
        this.authenticatorEnrollmentIds.add(authenticatorEnrollmentIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of IDs for preregistered WebAuthn Factors in Okta")
    @JsonProperty(value="authenticatorEnrollmentIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAuthenticatorEnrollmentIds() {
        return this.authenticatorEnrollmentIds;
    }

    @JsonProperty(value="authenticatorEnrollmentIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticatorEnrollmentIds(List<String> authenticatorEnrollmentIds) {
        this.authenticatorEnrollmentIds = authenticatorEnrollmentIds;
    }

    public EnrollmentActivationResponse fulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {
        this.fulfillmentProvider = fulfillmentProvider;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the fulfillment provider for the WebAuthn Preregistration Factor")
    @JsonProperty(value="fulfillmentProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FulfillmentProviderEnum getFulfillmentProvider() {
        return this.fulfillmentProvider;
    }

    @JsonProperty(value="fulfillmentProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {
        this.fulfillmentProvider = fulfillmentProvider;
    }

    public EnrollmentActivationResponse userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of an existing Okta user")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnrollmentActivationResponse enrollmentActivationResponse = (EnrollmentActivationResponse)o;
        return Objects.equals(this.authenticatorEnrollmentIds, enrollmentActivationResponse.authenticatorEnrollmentIds) && Objects.equals((Object)this.fulfillmentProvider, (Object)enrollmentActivationResponse.fulfillmentProvider) && Objects.equals(this.userId, enrollmentActivationResponse.userId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authenticatorEnrollmentIds, this.fulfillmentProvider, this.userId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnrollmentActivationResponse {\n");
        sb.append("    authenticatorEnrollmentIds: ").append(this.toIndentedString(this.authenticatorEnrollmentIds)).append("\n");
        sb.append("    fulfillmentProvider: ").append(this.toIndentedString((Object)this.fulfillmentProvider)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FulfillmentProviderEnum {
        YUBICO(String.valueOf("yubico")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private FulfillmentProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FulfillmentProviderEnum fromValue(String value) {
            for (FulfillmentProviderEnum b : FulfillmentProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

