package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Zoom app instance properties
 */
@ApiModel(description = "Zoom app instance properties")
@JsonPropertyOrder({ ZoomUsApplicationSettingsApplication.JSON_PROPERTY_SUB_DOMAIN })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ZoomUsApplicationSettingsApplication implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SUB_DOMAIN = "subDomain";
    private String subDomain;

    public ZoomUsApplicationSettingsApplication() {
    }

    public ZoomUsApplicationSettingsApplication subDomain(String subDomain) {

        this.subDomain = subDomain;
        return this;
    }

    /**
     * Your Zoom subdomain
     *
     * @return subDomain
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Your Zoom subdomain")
    @JsonProperty(JSON_PROPERTY_SUB_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getSubDomain() {
        return subDomain;
    }

    @JsonProperty(JSON_PROPERTY_SUB_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setSubDomain(String subDomain) {
        this.subDomain = subDomain;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ZoomUsApplicationSettingsApplication zoomUsApplicationSettingsApplication = (ZoomUsApplicationSettingsApplication) o;
        return Objects.equals(this.subDomain, zoomUsApplicationSettingsApplication.subDomain);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(subDomain);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ZoomUsApplicationSettingsApplication {\n");
        sb.append("    subDomain: ").append(toIndentedString(subDomain)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
