package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticatorKeyEnum;
import com.okta.sdk.resource.model.SupportedMethods;
import com.okta.sdk.resource.model.WellKnownAppAuthenticatorConfigurationSettings;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * WellKnownAppAuthenticatorConfiguration
 */
@JsonPropertyOrder({ WellKnownAppAuthenticatorConfiguration.JSON_PROPERTY_APP_AUTHENTICATOR_ENROLL_ENDPOINT,
        WellKnownAppAuthenticatorConfiguration.JSON_PROPERTY_AUTHENTICATOR_ID,
        WellKnownAppAuthenticatorConfiguration.JSON_PROPERTY_CREATED_DATE,
        WellKnownAppAuthenticatorConfiguration.JSON_PROPERTY_KEY,
        WellKnownAppAuthenticatorConfiguration.JSON_PROPERTY_LAST_UPDATED,
        WellKnownAppAuthenticatorConfiguration.JSON_PROPERTY_NAME,
        WellKnownAppAuthenticatorConfiguration.JSON_PROPERTY_ORG_ID,
        WellKnownAppAuthenticatorConfiguration.JSON_PROPERTY_SETTINGS,
        WellKnownAppAuthenticatorConfiguration.JSON_PROPERTY_SUPPORTED_METHODS,
        WellKnownAppAuthenticatorConfiguration.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class WellKnownAppAuthenticatorConfiguration implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_APP_AUTHENTICATOR_ENROLL_ENDPOINT = "appAuthenticatorEnrollEndpoint";
    private String appAuthenticatorEnrollEndpoint;

    public static final String JSON_PROPERTY_AUTHENTICATOR_ID = "authenticatorId";
    private String authenticatorId;

    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private OffsetDateTime createdDate;

    public static final String JSON_PROPERTY_KEY = "key";
    private AuthenticatorKeyEnum key;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_ORG_ID = "orgId";
    private String orgId;

    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private WellKnownAppAuthenticatorConfigurationSettings settings;

    public static final String JSON_PROPERTY_SUPPORTED_METHODS = "supportedMethods";
    private List<SupportedMethods> supportedMethods = null;

    /**
     * The type of Authenticator
     */
    public enum TypeEnum {
        APP(String.valueOf("app")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public WellKnownAppAuthenticatorConfiguration() {
    }

    public WellKnownAppAuthenticatorConfiguration appAuthenticatorEnrollEndpoint(
            String appAuthenticatorEnrollEndpoint) {

        this.appAuthenticatorEnrollEndpoint = appAuthenticatorEnrollEndpoint;
        return this;
    }

    /**
     * The authenticator enrollment endpoint
     *
     * @return appAuthenticatorEnrollEndpoint
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The authenticator enrollment endpoint")
    @JsonProperty(JSON_PROPERTY_APP_AUTHENTICATOR_ENROLL_ENDPOINT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAppAuthenticatorEnrollEndpoint() {
        return appAuthenticatorEnrollEndpoint;
    }

    @JsonProperty(JSON_PROPERTY_APP_AUTHENTICATOR_ENROLL_ENDPOINT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAppAuthenticatorEnrollEndpoint(String appAuthenticatorEnrollEndpoint) {
        this.appAuthenticatorEnrollEndpoint = appAuthenticatorEnrollEndpoint;
    }

    public WellKnownAppAuthenticatorConfiguration authenticatorId(String authenticatorId) {

        this.authenticatorId = authenticatorId;
        return this;
    }

    /**
     * The unique identifier of the app authenticator
     *
     * @return authenticatorId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The unique identifier of the app authenticator")
    @JsonProperty(JSON_PROPERTY_AUTHENTICATOR_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAuthenticatorId() {
        return authenticatorId;
    }

    @JsonProperty(JSON_PROPERTY_AUTHENTICATOR_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticatorId(String authenticatorId) {
        this.authenticatorId = authenticatorId;
    }

    public WellKnownAppAuthenticatorConfiguration createdDate(OffsetDateTime createdDate) {

        this.createdDate = createdDate;
        return this;
    }

    /**
     * Timestamp when the Authenticator was created
     *
     * @return createdDate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the Authenticator was created")
    @JsonProperty(JSON_PROPERTY_CREATED_DATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreatedDate() {
        return createdDate;
    }

    @JsonProperty(JSON_PROPERTY_CREATED_DATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedDate(OffsetDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public WellKnownAppAuthenticatorConfiguration key(AuthenticatorKeyEnum key) {

        this.key = key;
        return this;
    }

    /**
     * Get key
     *
     * @return key
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthenticatorKeyEnum getKey() {
        return key;
    }

    @JsonProperty(JSON_PROPERTY_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKey(AuthenticatorKeyEnum key) {
        this.key = key;
    }

    public WellKnownAppAuthenticatorConfiguration lastUpdated(OffsetDateTime lastUpdated) {

        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * Timestamp when the Authenticator was last modified
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the Authenticator was last modified")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdated(OffsetDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public WellKnownAppAuthenticatorConfiguration name(String name) {

        this.name = name;
        return this;
    }

    /**
     * The authenticator display name
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The authenticator display name")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public WellKnownAppAuthenticatorConfiguration orgId(String orgId) {

        this.orgId = orgId;
        return this;
    }

    /**
     * The &#x60;id&#x60; of the Okta Org
     *
     * @return orgId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The `id` of the Okta Org")
    @JsonProperty(JSON_PROPERTY_ORG_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOrgId() {
        return orgId;
    }

    @JsonProperty(JSON_PROPERTY_ORG_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public WellKnownAppAuthenticatorConfiguration settings(WellKnownAppAuthenticatorConfigurationSettings settings) {

        this.settings = settings;
        return this;
    }

    /**
     * Get settings
     *
     * @return settings
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public WellKnownAppAuthenticatorConfigurationSettings getSettings() {
        return settings;
    }

    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSettings(WellKnownAppAuthenticatorConfigurationSettings settings) {
        this.settings = settings;
    }

    public WellKnownAppAuthenticatorConfiguration supportedMethods(List<SupportedMethods> supportedMethods) {

        this.supportedMethods = supportedMethods;
        return this;
    }

    public WellKnownAppAuthenticatorConfiguration addsupportedMethodsItem(SupportedMethods supportedMethodsItem) {
        if (this.supportedMethods == null) {
            this.supportedMethods = new ArrayList<>();
        }
        this.supportedMethods.add(supportedMethodsItem);
        return this;
    }

    /**
     * Get supportedMethods
     *
     * @return supportedMethods
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SUPPORTED_METHODS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<SupportedMethods> getSupportedMethods() {
        return supportedMethods;
    }

    @JsonProperty(JSON_PROPERTY_SUPPORTED_METHODS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSupportedMethods(List<SupportedMethods> supportedMethods) {
        this.supportedMethods = supportedMethods;
    }

    public WellKnownAppAuthenticatorConfiguration type(TypeEnum type) {

        this.type = type;
        return this;
    }

    /**
     * The type of Authenticator
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The type of Authenticator")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TypeEnum getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        WellKnownAppAuthenticatorConfiguration wellKnownAppAuthenticatorConfiguration = (WellKnownAppAuthenticatorConfiguration) o;
        return Objects.equals(this.appAuthenticatorEnrollEndpoint,
                wellKnownAppAuthenticatorConfiguration.appAuthenticatorEnrollEndpoint)
                && Objects.equals(this.authenticatorId, wellKnownAppAuthenticatorConfiguration.authenticatorId)
                && Objects.equals(this.createdDate, wellKnownAppAuthenticatorConfiguration.createdDate)
                && Objects.equals(this.key, wellKnownAppAuthenticatorConfiguration.key)
                && Objects.equals(this.lastUpdated, wellKnownAppAuthenticatorConfiguration.lastUpdated)
                && Objects.equals(this.name, wellKnownAppAuthenticatorConfiguration.name)
                && Objects.equals(this.orgId, wellKnownAppAuthenticatorConfiguration.orgId)
                && Objects.equals(this.settings, wellKnownAppAuthenticatorConfiguration.settings)
                && Objects.equals(this.supportedMethods, wellKnownAppAuthenticatorConfiguration.supportedMethods)
                && Objects.equals(this.type, wellKnownAppAuthenticatorConfiguration.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(appAuthenticatorEnrollEndpoint, authenticatorId, createdDate, key, lastUpdated, name, orgId,
                settings, supportedMethods, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WellKnownAppAuthenticatorConfiguration {\n");
        sb.append("    appAuthenticatorEnrollEndpoint: ").append(toIndentedString(appAuthenticatorEnrollEndpoint))
                .append("\n");
        sb.append("    authenticatorId: ").append(toIndentedString(authenticatorId)).append("\n");
        sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
        sb.append("    key: ").append(toIndentedString(key)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    orgId: ").append(toIndentedString(orgId)).append("\n");
        sb.append("    settings: ").append(toIndentedString(settings)).append("\n");
        sb.append("    supportedMethods: ").append(toIndentedString(supportedMethods)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
