package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The current status of the user. The status of a User changes in response to explicit events, such as admin-driven
 * lifecycle changes, user login, or self-service password recovery. Okta doesn&#39;t asynchronously sweep through users
 * and update their password expiry state, for example. Instead, Okta evaluates password policy at login time, notices
 * the password has expired, and moves the User to the expired state. When running reports, remember that the data is
 * valid as of the last login or lifecycle event for that user.
 */
public enum UserStatus {

    ACTIVE("ACTIVE"),

    DEPROVISIONED("DEPROVISIONED"),

    LOCKED_OUT("LOCKED_OUT"),

    PASSWORD_EXPIRED("PASSWORD_EXPIRED"),

    PROVISIONED("PROVISIONED"),

    RECOVERY("RECOVERY"),

    STAGED("STAGED"),

    SUSPENDED("SUSPENDED"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    UserStatus(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static UserStatus fromValue(String value) {
        for (UserStatus b : UserStatus.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
