package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserRiskRequest
 */
@JsonPropertyOrder({ UserRiskRequest.JSON_PROPERTY_RISK_LEVEL })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UserRiskRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * The risk level associated with the user
     */
    public enum RiskLevelEnum {
        HIGH(String.valueOf("HIGH")),

        LOW(String.valueOf("LOW")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        RiskLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static RiskLevelEnum fromValue(String value) {
            for (RiskLevelEnum b : RiskLevelEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_RISK_LEVEL = "riskLevel";
    private RiskLevelEnum riskLevel;

    public UserRiskRequest() {
    }

    public UserRiskRequest riskLevel(RiskLevelEnum riskLevel) {

        this.riskLevel = riskLevel;
        return this;
    }

    /**
     * The risk level associated with the user
     *
     * @return riskLevel
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The risk level associated with the user")
    @JsonProperty(JSON_PROPERTY_RISK_LEVEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RiskLevelEnum getRiskLevel() {
        return riskLevel;
    }

    @JsonProperty(JSON_PROPERTY_RISK_LEVEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRiskLevel(RiskLevelEnum riskLevel) {
        this.riskLevel = riskLevel;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserRiskRequest userRiskRequest = (UserRiskRequest) o;
        return Objects.equals(this.riskLevel, userRiskRequest.riskLevel);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(riskLevel);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserRiskRequest {\n");
        sb.append("    riskLevel: ").append(toIndentedString(riskLevel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
