package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationFeature;
import com.okta.sdk.resource.model.ApplicationFeatureLinks;
import com.okta.sdk.resource.model.ApplicationFeatureType;
import com.okta.sdk.resource.model.CapabilitiesObject;
import com.okta.sdk.resource.model.EnabledStatus;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserProvisioningApplicationFeature
 */
@JsonPropertyOrder({ UserProvisioningApplicationFeature.JSON_PROPERTY_CAPABILITIES })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "name", visible = true, defaultImpl = UserProvisioningApplicationFeature.class)

public class UserProvisioningApplicationFeature extends ApplicationFeature implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
    private CapabilitiesObject capabilities;

    public UserProvisioningApplicationFeature() {
    }

    /*
     * @JsonCreator public UserProvisioningApplicationFeature(
     *
     * @JsonProperty(JSON_PROPERTY_DESCRIPTION) String description ) { this(); this.description = description; }
     */

    public UserProvisioningApplicationFeature capabilities(CapabilitiesObject capabilities) {

        this.capabilities = capabilities;
        return this;
    }

    /**
     * Get capabilities
     *
     * @return capabilities
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CAPABILITIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public CapabilitiesObject getCapabilities() {
        return capabilities;
    }

    @JsonProperty(JSON_PROPERTY_CAPABILITIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCapabilities(CapabilitiesObject capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserProvisioningApplicationFeature userProvisioningApplicationFeature = (UserProvisioningApplicationFeature) o;
        return Objects.equals(this.capabilities, userProvisioningApplicationFeature.capabilities);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(capabilities, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserProvisioningApplicationFeature {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    capabilities: ").append(toIndentedString(capabilities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
