package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserImportRequestDataContextApplication;
import com.okta.sdk.resource.model.UserImportRequestDataContextJob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserImportRequestDataContext
 */
@JsonPropertyOrder({ UserImportRequestDataContext.JSON_PROPERTY_CONFLICTS,
        UserImportRequestDataContext.JSON_PROPERTY_APPLICATION, UserImportRequestDataContext.JSON_PROPERTY_JOB,
        UserImportRequestDataContext.JSON_PROPERTY_MATCHES, UserImportRequestDataContext.JSON_PROPERTY_POLICY })
@JsonTypeName("UserImportRequestData_context")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UserImportRequestDataContext implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONFLICTS = "conflicts";
    private List<Map<String, Object>> conflicts = null;

    public static final String JSON_PROPERTY_APPLICATION = "application";
    private UserImportRequestDataContextApplication application;

    public static final String JSON_PROPERTY_JOB = "job";
    private UserImportRequestDataContextJob job;

    public static final String JSON_PROPERTY_MATCHES = "matches";
    private List<Map<String, Object>> matches = null;

    public static final String JSON_PROPERTY_POLICY = "policy";
    private List<Map<String, Object>> policy = null;

    public UserImportRequestDataContext() {
    }

    public UserImportRequestDataContext conflicts(List<Map<String, Object>> conflicts) {

        this.conflicts = conflicts;
        return this;
    }

    public UserImportRequestDataContext addconflictsItem(Map<String, Object> conflictsItem) {
        if (this.conflicts == null) {
            this.conflicts = new ArrayList<>();
        }
        this.conflicts.add(conflictsItem);
        return this;
    }

    /**
     * An array of user profile attributes that are in conflict
     *
     * @return conflicts
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "An array of user profile attributes that are in conflict")
    @JsonProperty(JSON_PROPERTY_CONFLICTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<Map<String, Object>> getConflicts() {
        return conflicts;
    }

    @JsonProperty(JSON_PROPERTY_CONFLICTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConflicts(List<Map<String, Object>> conflicts) {
        this.conflicts = conflicts;
    }

    public UserImportRequestDataContext application(UserImportRequestDataContextApplication application) {

        this.application = application;
        return this;
    }

    /**
     * Get application
     *
     * @return application
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_APPLICATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserImportRequestDataContextApplication getApplication() {
        return application;
    }

    @JsonProperty(JSON_PROPERTY_APPLICATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setApplication(UserImportRequestDataContextApplication application) {
        this.application = application;
    }

    public UserImportRequestDataContext job(UserImportRequestDataContextJob job) {

        this.job = job;
        return this;
    }

    /**
     * Get job
     *
     * @return job
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_JOB)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserImportRequestDataContextJob getJob() {
        return job;
    }

    @JsonProperty(JSON_PROPERTY_JOB)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setJob(UserImportRequestDataContextJob job) {
        this.job = job;
    }

    public UserImportRequestDataContext matches(List<Map<String, Object>> matches) {

        this.matches = matches;
        return this;
    }

    public UserImportRequestDataContext addmatchesItem(Map<String, Object> matchesItem) {
        if (this.matches == null) {
            this.matches = new ArrayList<>();
        }
        this.matches.add(matchesItem);
        return this;
    }

    /**
     * The list of Okta users currently matched to the app user based on import matching. There can be more than one
     * match.
     *
     * @return matches
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The list of Okta users currently matched to the app user based on import matching. There can be more than one match.")
    @JsonProperty(JSON_PROPERTY_MATCHES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<Map<String, Object>> getMatches() {
        return matches;
    }

    @JsonProperty(JSON_PROPERTY_MATCHES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMatches(List<Map<String, Object>> matches) {
        this.matches = matches;
    }

    public UserImportRequestDataContext policy(List<Map<String, Object>> policy) {

        this.policy = policy;
        return this;
    }

    public UserImportRequestDataContext addpolicyItem(Map<String, Object> policyItem) {
        if (this.policy == null) {
            this.policy = new ArrayList<>();
        }
        this.policy.add(policyItem);
        return this;
    }

    /**
     * The list of any policies that apply to the import matching
     *
     * @return policy
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The list of any policies that apply to the import matching")
    @JsonProperty(JSON_PROPERTY_POLICY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<Map<String, Object>> getPolicy() {
        return policy;
    }

    @JsonProperty(JSON_PROPERTY_POLICY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(List<Map<String, Object>> policy) {
        this.policy = policy;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserImportRequestDataContext userImportRequestDataContext = (UserImportRequestDataContext) o;
        return Objects.equals(this.conflicts, userImportRequestDataContext.conflicts)
                && Objects.equals(this.application, userImportRequestDataContext.application)
                && Objects.equals(this.job, userImportRequestDataContext.job)
                && Objects.equals(this.matches, userImportRequestDataContext.matches)
                && Objects.equals(this.policy, userImportRequestDataContext.policy);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(conflicts, application, job, matches, policy);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserImportRequestDataContext {\n");
        sb.append("    conflicts: ").append(toIndentedString(conflicts)).append("\n");
        sb.append("    application: ").append(toIndentedString(application)).append("\n");
        sb.append("    job: ").append(toIndentedString(job)).append("\n");
        sb.append("    matches: ").append(toIndentedString(matches)).append("\n");
        sb.append("    policy: ").append(toIndentedString(policy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
