package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserFactorPushProfile
 */
@JsonPropertyOrder({ UserFactorPushProfile.JSON_PROPERTY_CREDENTIAL_ID,
        UserFactorPushProfile.JSON_PROPERTY_DEVICE_TOKEN, UserFactorPushProfile.JSON_PROPERTY_DEVICE_TYPE,
        UserFactorPushProfile.JSON_PROPERTY_NAME, UserFactorPushProfile.JSON_PROPERTY_PLATFORM,
        UserFactorPushProfile.JSON_PROPERTY_VERSION })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UserFactorPushProfile implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREDENTIAL_ID = "credentialId";
    private String credentialId;

    public static final String JSON_PROPERTY_DEVICE_TOKEN = "deviceToken";
    private String deviceToken;

    public static final String JSON_PROPERTY_DEVICE_TYPE = "deviceType";
    private String deviceType;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_PLATFORM = "platform";
    private String platform;

    public static final String JSON_PROPERTY_VERSION = "version";
    private String version;

    public UserFactorPushProfile() {
    }

    public UserFactorPushProfile credentialId(String credentialId) {

        this.credentialId = credentialId;
        return this;
    }

    /**
     * ID for the Factor credential
     *
     * @return credentialId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "dade.murphy@example.com", value = "ID for the Factor credential")
    @JsonProperty(JSON_PROPERTY_CREDENTIAL_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCredentialId() {
        return credentialId;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIAL_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    public UserFactorPushProfile deviceToken(String deviceToken) {

        this.deviceToken = deviceToken;
        return this;
    }

    /**
     * Token used to identify the device
     *
     * @return deviceToken
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "fwf7ku6bsiSCieh6y1d7", value = "Token used to identify the device")
    @JsonProperty(JSON_PROPERTY_DEVICE_TOKEN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDeviceToken() {
        return deviceToken;
    }

    @JsonProperty(JSON_PROPERTY_DEVICE_TOKEN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
    }

    public UserFactorPushProfile deviceType(String deviceType) {

        this.deviceType = deviceType;
        return this;
    }

    /**
     * Type of device
     *
     * @return deviceType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "SmartPhone_IPhone", value = "Type of device")
    @JsonProperty(JSON_PROPERTY_DEVICE_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDeviceType() {
        return deviceType;
    }

    @JsonProperty(JSON_PROPERTY_DEVICE_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public UserFactorPushProfile name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Name of the device
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "My Phone", value = "Name of the device")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public UserFactorPushProfile platform(String platform) {

        this.platform = platform;
        return this;
    }

    /**
     * OS version of the associated device
     *
     * @return platform
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "IOS", value = "OS version of the associated device")
    @JsonProperty(JSON_PROPERTY_PLATFORM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPlatform() {
        return platform;
    }

    @JsonProperty(JSON_PROPERTY_PLATFORM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public UserFactorPushProfile version(String version) {

        this.version = version;
        return this;
    }

    /**
     * Installed version of Okta Verify
     *
     * @return version
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "9.0", value = "Installed version of Okta Verify")
    @JsonProperty(JSON_PROPERTY_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getVersion() {
        return version;
    }

    @JsonProperty(JSON_PROPERTY_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserFactorPushProfile userFactorPushProfile = (UserFactorPushProfile) o;
        return Objects.equals(this.credentialId, userFactorPushProfile.credentialId)
                && Objects.equals(this.deviceToken, userFactorPushProfile.deviceToken)
                && Objects.equals(this.deviceType, userFactorPushProfile.deviceType)
                && Objects.equals(this.name, userFactorPushProfile.name)
                && Objects.equals(this.platform, userFactorPushProfile.platform)
                && Objects.equals(this.version, userFactorPushProfile.version);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(credentialId, deviceToken, deviceType, name, platform, version);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorPushProfile {\n");
        sb.append("    credentialId: ").append(toIndentedString(credentialId)).append("\n");
        sb.append("    deviceToken: ").append(toIndentedString(deviceToken)).append("\n");
        sb.append("    deviceType: ").append(toIndentedString(deviceType)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    platform: ").append(toIndentedString(platform)).append("\n");
        sb.append("    version: ").append(toIndentedString(version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
