package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserFactorActivatePushResult;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Activation requests have a short lifetime and expire if the activation isn&#39;t completed before the indicated
 * timestamp. If the activation expires, use the returned &#x60;activate&#x60; link to restart the process.
 */
@ApiModel(description = "Activation requests have a short lifetime and expire if the activation isn't completed before the indicated timestamp. If the activation expires, use the returned `activate` link to restart the process.")
@JsonPropertyOrder({ UserFactorActivatePush.JSON_PROPERTY_EXPIRES_AT,
        UserFactorActivatePush.JSON_PROPERTY_FACTOR_RESULT })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UserFactorActivatePush implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;

    public static final String JSON_PROPERTY_FACTOR_RESULT = "factorResult";
    private UserFactorActivatePushResult factorResult;

    public UserFactorActivatePush() {
    }

    /*
     * @JsonCreator public UserFactorActivatePush(
     *
     * @JsonProperty(JSON_PROPERTY_EXPIRES_AT) OffsetDateTime expiresAt ) { this(); this.expiresAt = expiresAt; }
     */

    /**
     * Timestamp when the Factor verification attempt expires
     *
     * @return expiresAt
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2022-08-25T00:31Z", value = "Timestamp when the Factor verification attempt expires")
    @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getExpiresAt() {
        return expiresAt;
    }

    public UserFactorActivatePush factorResult(UserFactorActivatePushResult factorResult) {

        this.factorResult = factorResult;
        return this;
    }

    /**
     * Get factorResult
     *
     * @return factorResult
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_FACTOR_RESULT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorActivatePushResult getFactorResult() {
        return factorResult;
    }

    @JsonProperty(JSON_PROPERTY_FACTOR_RESULT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFactorResult(UserFactorActivatePushResult factorResult) {
        this.factorResult = factorResult;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserFactorActivatePush userFactorActivatePush = (UserFactorActivatePush) o;
        return Objects.equals(this.expiresAt, userFactorActivatePush.expiresAt)
                && Objects.equals(this.factorResult, userFactorActivatePush.factorResult);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(expiresAt, factorResult);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorActivatePush {\n");
        sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
        sb.append("    factorResult: ").append(toIndentedString(factorResult)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
