package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Contains information about the intended SET delivery method by the receiver
 */
@ApiModel(description = "Contains information about the intended SET delivery method by the receiver")
@JsonPropertyOrder({ StreamConfigurationDelivery.JSON_PROPERTY_AUTHORIZATION_HEADER,
        StreamConfigurationDelivery.JSON_PROPERTY_ENDPOINT_URL, StreamConfigurationDelivery.JSON_PROPERTY_METHOD })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class StreamConfigurationDelivery implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUTHORIZATION_HEADER = "authorization_header";
    private JsonNullable<String> authorizationHeader = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_ENDPOINT_URL = "endpoint_url";
    private URI endpointUrl;

    /**
     * The delivery method that the transmitter uses for delivering a SET
     */
    public enum MethodEnum {
        HTTPS_SCHEMAS_OPENID_NET_SECEVENT_RISC_DELIVERY_METHOD_PUSH(
                String.valueOf("https://schemas.openid.net/secevent/risc/delivery-method/push")),

        URN_IETF_RFC_8935(String.valueOf("urn:ietf:rfc:8935")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        MethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static MethodEnum fromValue(String value) {
            for (MethodEnum b : MethodEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_METHOD = "method";
    private MethodEnum method;

    public StreamConfigurationDelivery() {
    }

    public StreamConfigurationDelivery authorizationHeader(String authorizationHeader) {
        this.authorizationHeader = JsonNullable.<String> of(authorizationHeader);

        return this;
    }

    /**
     * The HTTP Authorization header that is included for each HTTP POST request
     *
     * @return authorizationHeader
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "{authorizationHeaderValue}", value = "The HTTP Authorization header that is included for each HTTP POST request")
    @JsonIgnore

    public String getAuthorizationHeader() {
        return authorizationHeader.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_AUTHORIZATION_HEADER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getAuthorizationHeader_JsonNullable() {
        return authorizationHeader;
    }

    @JsonProperty(JSON_PROPERTY_AUTHORIZATION_HEADER)
    public void setAuthorizationHeader_JsonNullable(JsonNullable<String> authorizationHeader) {
        this.authorizationHeader = authorizationHeader;
    }

    public void setAuthorizationHeader(String authorizationHeader) {
        this.authorizationHeader = JsonNullable.<String> of(authorizationHeader);
    }

    public StreamConfigurationDelivery endpointUrl(URI endpointUrl) {

        this.endpointUrl = endpointUrl;
        return this;
    }

    /**
     * The target endpoint URL where the transmitter delivers the SET using HTTP POST requests
     *
     * @return endpointUrl
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "https://example.com/", required = true, value = "The target endpoint URL where the transmitter delivers the SET using HTTP POST requests")
    @JsonProperty(JSON_PROPERTY_ENDPOINT_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public URI getEndpointUrl() {
        return endpointUrl;
    }

    @JsonProperty(JSON_PROPERTY_ENDPOINT_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setEndpointUrl(URI endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public StreamConfigurationDelivery method(MethodEnum method) {

        this.method = method;
        return this;
    }

    /**
     * The delivery method that the transmitter uses for delivering a SET
     *
     * @return method
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The delivery method that the transmitter uses for delivering a SET")
    @JsonProperty(JSON_PROPERTY_METHOD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public MethodEnum getMethod() {
        return method;
    }

    @JsonProperty(JSON_PROPERTY_METHOD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setMethod(MethodEnum method) {
        this.method = method;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StreamConfigurationDelivery streamConfigurationDelivery = (StreamConfigurationDelivery) o;
        return equalsNullable(this.authorizationHeader, streamConfigurationDelivery.authorizationHeader)
                && Objects.equals(this.endpointUrl, streamConfigurationDelivery.endpointUrl)
                && Objects.equals(this.method, streamConfigurationDelivery.method);
        // ;
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(hashCodeNullable(authorizationHeader), endpointUrl, method);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StreamConfigurationDelivery {\n");
        sb.append("    authorizationHeader: ").append(toIndentedString(authorizationHeader)).append("\n");
        sb.append("    endpointUrl: ").append(toIndentedString(endpointUrl)).append("\n");
        sb.append("    method: ").append(toIndentedString(method)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
