package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Determines if the app participates in Single Logout (SLO)
 */
@ApiModel(description = "Determines if the app participates in Single Logout (SLO)")
@JsonPropertyOrder({ SloParticipate.JSON_PROPERTY_BINDING_TYPE, SloParticipate.JSON_PROPERTY_ENABLED,
        SloParticipate.JSON_PROPERTY_LOGOUT_REQUEST_URL, SloParticipate.JSON_PROPERTY_SESSION_INDEX_REQUIRED })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SloParticipate implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Request binding type
     */
    public enum BindingTypeEnum {
        POST(String.valueOf("POST")),

        REDIRECT(String.valueOf("REDIRECT")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        BindingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static BindingTypeEnum fromValue(String value) {
            for (BindingTypeEnum b : BindingTypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_BINDING_TYPE = "bindingType";
    private BindingTypeEnum bindingType;

    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;

    public static final String JSON_PROPERTY_LOGOUT_REQUEST_URL = "logoutRequestUrl";
    private String logoutRequestUrl;

    public static final String JSON_PROPERTY_SESSION_INDEX_REQUIRED = "sessionIndexRequired";
    private Boolean sessionIndexRequired;

    public SloParticipate() {
    }

    public SloParticipate bindingType(BindingTypeEnum bindingType) {

        this.bindingType = bindingType;
        return this;
    }

    /**
     * Request binding type
     *
     * @return bindingType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Request binding type")
    @JsonProperty(JSON_PROPERTY_BINDING_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BindingTypeEnum getBindingType() {
        return bindingType;
    }

    @JsonProperty(JSON_PROPERTY_BINDING_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBindingType(BindingTypeEnum bindingType) {
        this.bindingType = bindingType;
    }

    public SloParticipate enabled(Boolean enabled) {

        this.enabled = enabled;
        return this;
    }

    /**
     * Indicates whether the app is allowed to participate in front-channel SLO
     *
     * @return enabled
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether the app is allowed to participate in front-channel SLO")
    @JsonProperty(JSON_PROPERTY_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getEnabled() {
        return enabled;
    }

    @JsonProperty(JSON_PROPERTY_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public SloParticipate logoutRequestUrl(String logoutRequestUrl) {

        this.logoutRequestUrl = logoutRequestUrl;
        return this;
    }

    /**
     * URL where Okta sends the logout request
     *
     * @return logoutRequestUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "URL where Okta sends the logout request")
    @JsonProperty(JSON_PROPERTY_LOGOUT_REQUEST_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLogoutRequestUrl() {
        return logoutRequestUrl;
    }

    @JsonProperty(JSON_PROPERTY_LOGOUT_REQUEST_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLogoutRequestUrl(String logoutRequestUrl) {
        this.logoutRequestUrl = logoutRequestUrl;
    }

    public SloParticipate sessionIndexRequired(Boolean sessionIndexRequired) {

        this.sessionIndexRequired = sessionIndexRequired;
        return this;
    }

    /**
     * Determines whether Okta sends the &#x60;SessionIndex&#x60; elements in the logout request
     *
     * @return sessionIndexRequired
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Determines whether Okta sends the `SessionIndex` elements in the logout request")
    @JsonProperty(JSON_PROPERTY_SESSION_INDEX_REQUIRED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSessionIndexRequired() {
        return sessionIndexRequired;
    }

    @JsonProperty(JSON_PROPERTY_SESSION_INDEX_REQUIRED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSessionIndexRequired(Boolean sessionIndexRequired) {
        this.sessionIndexRequired = sessionIndexRequired;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SloParticipate sloParticipate = (SloParticipate) o;
        return Objects.equals(this.bindingType, sloParticipate.bindingType)
                && Objects.equals(this.enabled, sloParticipate.enabled)
                && Objects.equals(this.logoutRequestUrl, sloParticipate.logoutRequestUrl)
                && Objects.equals(this.sessionIndexRequired, sloParticipate.sessionIndexRequired);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(bindingType, enabled, logoutRequestUrl, sessionIndexRequired);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SloParticipate {\n");
        sb.append("    bindingType: ").append(toIndentedString(bindingType)).append("\n");
        sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
        sb.append("    logoutRequestUrl: ").append(toIndentedString(logoutRequestUrl)).append("\n");
        sb.append("    sessionIndexRequired: ").append(toIndentedString(sessionIndexRequired)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
