package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ContentSecurityPolicySetting;
import com.okta.sdk.resource.model.SignInPageAllOfWidgetCustomizations;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SignInPage
 */
@JsonPropertyOrder({ SignInPage.JSON_PROPERTY_PAGE_CONTENT, SignInPage.JSON_PROPERTY_CONTENT_SECURITY_POLICY_SETTING,
        SignInPage.JSON_PROPERTY_WIDGET_CUSTOMIZATIONS, SignInPage.JSON_PROPERTY_WIDGET_VERSION })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SignInPage implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PAGE_CONTENT = "pageContent";
    private String pageContent;

    public static final String JSON_PROPERTY_CONTENT_SECURITY_POLICY_SETTING = "contentSecurityPolicySetting";
    private ContentSecurityPolicySetting contentSecurityPolicySetting;

    public static final String JSON_PROPERTY_WIDGET_CUSTOMIZATIONS = "widgetCustomizations";
    private SignInPageAllOfWidgetCustomizations widgetCustomizations;

    public static final String JSON_PROPERTY_WIDGET_VERSION = "widgetVersion";
    private String widgetVersion;

    public SignInPage() {
    }

    public SignInPage pageContent(String pageContent) {

        this.pageContent = pageContent;
        return this;
    }

    /**
     * The HTML for the page
     *
     * @return pageContent
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The HTML for the page")
    @JsonProperty(JSON_PROPERTY_PAGE_CONTENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPageContent() {
        return pageContent;
    }

    @JsonProperty(JSON_PROPERTY_PAGE_CONTENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPageContent(String pageContent) {
        this.pageContent = pageContent;
    }

    public SignInPage contentSecurityPolicySetting(ContentSecurityPolicySetting contentSecurityPolicySetting) {

        this.contentSecurityPolicySetting = contentSecurityPolicySetting;
        return this;
    }

    /**
     * Get contentSecurityPolicySetting
     *
     * @return contentSecurityPolicySetting
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONTENT_SECURITY_POLICY_SETTING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ContentSecurityPolicySetting getContentSecurityPolicySetting() {
        return contentSecurityPolicySetting;
    }

    @JsonProperty(JSON_PROPERTY_CONTENT_SECURITY_POLICY_SETTING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setContentSecurityPolicySetting(ContentSecurityPolicySetting contentSecurityPolicySetting) {
        this.contentSecurityPolicySetting = contentSecurityPolicySetting;
    }

    public SignInPage widgetCustomizations(SignInPageAllOfWidgetCustomizations widgetCustomizations) {

        this.widgetCustomizations = widgetCustomizations;
        return this;
    }

    /**
     * Get widgetCustomizations
     *
     * @return widgetCustomizations
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_WIDGET_CUSTOMIZATIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SignInPageAllOfWidgetCustomizations getWidgetCustomizations() {
        return widgetCustomizations;
    }

    @JsonProperty(JSON_PROPERTY_WIDGET_CUSTOMIZATIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setWidgetCustomizations(SignInPageAllOfWidgetCustomizations widgetCustomizations) {
        this.widgetCustomizations = widgetCustomizations;
    }

    public SignInPage widgetVersion(String widgetVersion) {

        this.widgetVersion = widgetVersion;
        return this;
    }

    /**
     * The version specified as a [Semantic Version](https://semver.org/).
     *
     * @return widgetVersion
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The version specified as a [Semantic Version](https://semver.org/).")
    @JsonProperty(JSON_PROPERTY_WIDGET_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getWidgetVersion() {
        return widgetVersion;
    }

    @JsonProperty(JSON_PROPERTY_WIDGET_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setWidgetVersion(String widgetVersion) {
        this.widgetVersion = widgetVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SignInPage signInPage = (SignInPage) o;
        return Objects.equals(this.pageContent, signInPage.pageContent)
                && Objects.equals(this.contentSecurityPolicySetting, signInPage.contentSecurityPolicySetting)
                && Objects.equals(this.widgetCustomizations, signInPage.widgetCustomizations)
                && Objects.equals(this.widgetVersion, signInPage.widgetVersion);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(pageContent, contentSecurityPolicySetting, widgetCustomizations, widgetVersion);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignInPage {\n");
        sb.append("    pageContent: ").append(toIndentedString(pageContent)).append("\n");
        sb.append("    contentSecurityPolicySetting: ").append(toIndentedString(contentSecurityPolicySetting))
                .append("\n");
        sb.append("    widgetCustomizations: ").append(toIndentedString(widgetCustomizations)).append("\n");
        sb.append("    widgetVersion: ").append(toIndentedString(widgetVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
