package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SamlNameIdFormat;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Advanced settings for the SAML 2.0 protocol
 */
@ApiModel(description = "Advanced settings for the SAML 2.0 protocol")
@JsonPropertyOrder({ SamlSettings.JSON_PROPERTY_HONOR_PERSISTENT_NAME_ID, SamlSettings.JSON_PROPERTY_NAME_FORMAT })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SamlSettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_HONOR_PERSISTENT_NAME_ID = "honorPersistentNameId";
    private Boolean honorPersistentNameId = true;

    public static final String JSON_PROPERTY_NAME_FORMAT = "nameFormat";
    private SamlNameIdFormat nameFormat = SamlNameIdFormat.URN_OASIS_NAMES_TC_SAML_1_1_NAMEID_FORMAT_UNSPECIFIED;

    public SamlSettings() {
    }

    public SamlSettings honorPersistentNameId(Boolean honorPersistentNameId) {

        this.honorPersistentNameId = honorPersistentNameId;
        return this;
    }

    /**
     * Determines if the IdP should persist account linking when the incoming assertion NameID format is
     * &#x60;urn:oasis:names:tc:SAML:2.0:nameid-format:persistent&#x60;
     *
     * @return honorPersistentNameId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Determines if the IdP should persist account linking when the incoming assertion NameID format is `urn:oasis:names:tc:SAML:2.0:nameid-format:persistent`")
    @JsonProperty(JSON_PROPERTY_HONOR_PERSISTENT_NAME_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getHonorPersistentNameId() {
        return honorPersistentNameId;
    }

    @JsonProperty(JSON_PROPERTY_HONOR_PERSISTENT_NAME_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHonorPersistentNameId(Boolean honorPersistentNameId) {
        this.honorPersistentNameId = honorPersistentNameId;
    }

    public SamlSettings nameFormat(SamlNameIdFormat nameFormat) {

        this.nameFormat = nameFormat;
        return this;
    }

    /**
     * Get nameFormat
     *
     * @return nameFormat
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NAME_FORMAT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SamlNameIdFormat getNameFormat() {
        return nameFormat;
    }

    @JsonProperty(JSON_PROPERTY_NAME_FORMAT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNameFormat(SamlNameIdFormat nameFormat) {
        this.nameFormat = nameFormat;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SamlSettings samlSettings = (SamlSettings) o;
        return Objects.equals(this.honorPersistentNameId, samlSettings.honorPersistentNameId)
                && Objects.equals(this.nameFormat, samlSettings.nameFormat);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(honorPersistentNameId, nameFormat);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlSettings {\n");
        sb.append("    honorPersistentNameId: ").append(toIndentedString(honorPersistentNameId)).append("\n");
        sb.append("    nameFormat: ").append(toIndentedString(nameFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
