package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.DetectedRiskEvents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * &lt;x-lifecycle class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt; An object that references detected risk events.
 * This object can have an &#x60;include&#x60; parameter or an &#x60;exclude&#x60; parameter, but not both.
 */
@ApiModel(description = "<x-lifecycle class=\"oie\"></x-lifecycle> An object that references detected risk events. This object can have an `include` parameter or an `exclude` parameter, but not both.")
@JsonPropertyOrder({ RiskDetectionTypesPolicyRuleCondition.JSON_PROPERTY_EXCLUDE,
        RiskDetectionTypesPolicyRuleCondition.JSON_PROPERTY_INCLUDE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class RiskDetectionTypesPolicyRuleCondition implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EXCLUDE = "exclude";
    private List<DetectedRiskEvents> exclude = new ArrayList<>();

    public static final String JSON_PROPERTY_INCLUDE = "include";
    private List<DetectedRiskEvents> include = new ArrayList<>();

    public RiskDetectionTypesPolicyRuleCondition() {
    }

    public RiskDetectionTypesPolicyRuleCondition exclude(List<DetectedRiskEvents> exclude) {

        this.exclude = exclude;
        return this;
    }

    public RiskDetectionTypesPolicyRuleCondition addexcludeItem(DetectedRiskEvents excludeItem) {
        if (this.exclude == null) {
            this.exclude = new ArrayList<>();
        }
        this.exclude.add(excludeItem);
        return this;
    }

    /**
     * An array of detected risk events to exclude in the entity policy rule
     *
     * @return exclude
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "An array of detected risk events to exclude in the entity policy rule")
    @JsonProperty(JSON_PROPERTY_EXCLUDE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public List<DetectedRiskEvents> getExclude() {
        return exclude;
    }

    @JsonProperty(JSON_PROPERTY_EXCLUDE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setExclude(List<DetectedRiskEvents> exclude) {
        this.exclude = exclude;
    }

    public RiskDetectionTypesPolicyRuleCondition include(List<DetectedRiskEvents> include) {

        this.include = include;
        return this;
    }

    public RiskDetectionTypesPolicyRuleCondition addincludeItem(DetectedRiskEvents includeItem) {
        if (this.include == null) {
            this.include = new ArrayList<>();
        }
        this.include.add(includeItem);
        return this;
    }

    /**
     * An array of detected risk events to include in the entity policy rule
     *
     * @return include
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "An array of detected risk events to include in the entity policy rule")
    @JsonProperty(JSON_PROPERTY_INCLUDE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public List<DetectedRiskEvents> getInclude() {
        return include;
    }

    @JsonProperty(JSON_PROPERTY_INCLUDE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setInclude(List<DetectedRiskEvents> include) {
        this.include = include;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RiskDetectionTypesPolicyRuleCondition riskDetectionTypesPolicyRuleCondition = (RiskDetectionTypesPolicyRuleCondition) o;
        return Objects.equals(this.exclude, riskDetectionTypesPolicyRuleCondition.exclude)
                && Objects.equals(this.include, riskDetectionTypesPolicyRuleCondition.include);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(exclude, include);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RiskDetectionTypesPolicyRuleCondition {\n");
        sb.append("    exclude: ").append(toIndentedString(exclude)).append("\n");
        sb.append("    include: ").append(toIndentedString(include)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
