package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ResourceSelectorResponseWithoutSelfLinkSchemaLinks;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * ResourceSelectorResponseWithoutSelfLinkSchema
 */
@JsonPropertyOrder({ ResourceSelectorResponseWithoutSelfLinkSchema.JSON_PROPERTY_DESCRIPTION,
        ResourceSelectorResponseWithoutSelfLinkSchema.JSON_PROPERTY_ID,
        ResourceSelectorResponseWithoutSelfLinkSchema.JSON_PROPERTY_NAME,
        ResourceSelectorResponseWithoutSelfLinkSchema.JSON_PROPERTY_ORN,
        ResourceSelectorResponseWithoutSelfLinkSchema.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ResourceSelectorResponseWithoutSelfLinkSchema implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_ORN = "orn";
    private String orn;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private ResourceSelectorResponseWithoutSelfLinkSchemaLinks links;

    public ResourceSelectorResponseWithoutSelfLinkSchema() {
    }

    public ResourceSelectorResponseWithoutSelfLinkSchema description(String description) {

        this.description = description;
        return this;
    }

    /**
     * Description of the Resource Selector
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Description of the Resource Selector")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceSelectorResponseWithoutSelfLinkSchema id(String id) {

        this.id = id;
        return this;
    }

    /**
     * Unique key for the Resource Selector
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique key for the Resource Selector")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public ResourceSelectorResponseWithoutSelfLinkSchema name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Name of the Resource Selector
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the Resource Selector")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ResourceSelectorResponseWithoutSelfLinkSchema orn(String orn) {

        this.orn = orn;
        return this;
    }

    /**
     * An Okta resource name
     *
     * @return orn
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "An Okta resource name")
    @JsonProperty(JSON_PROPERTY_ORN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOrn() {
        return orn;
    }

    @JsonProperty(JSON_PROPERTY_ORN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOrn(String orn) {
        this.orn = orn;
    }

    public ResourceSelectorResponseWithoutSelfLinkSchema links(
            ResourceSelectorResponseWithoutSelfLinkSchemaLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ResourceSelectorResponseWithoutSelfLinkSchemaLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(ResourceSelectorResponseWithoutSelfLinkSchemaLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceSelectorResponseWithoutSelfLinkSchema resourceSelectorResponseWithoutSelfLinkSchema = (ResourceSelectorResponseWithoutSelfLinkSchema) o;
        return Objects.equals(this.description, resourceSelectorResponseWithoutSelfLinkSchema.description)
                && Objects.equals(this.id, resourceSelectorResponseWithoutSelfLinkSchema.id)
                && Objects.equals(this.name, resourceSelectorResponseWithoutSelfLinkSchema.name)
                && Objects.equals(this.orn, resourceSelectorResponseWithoutSelfLinkSchema.orn)
                && Objects.equals(this.links, resourceSelectorResponseWithoutSelfLinkSchema.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(description, id, name, orn, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceSelectorResponseWithoutSelfLinkSchema {\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    orn: ").append(toIndentedString(orn)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
