package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The type of registration hook. Use either &#x60;self.service.registration&#x60; or &#x60;progressive.profile&#x60;.
 */
public enum RegistrationInlineHookRequestType {

    PROGRESSIVE_PROFILE("progressive.profile"),

    SELF_SERVICE_REGISTRATION("self.service.registration"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    RegistrationInlineHookRequestType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static RegistrationInlineHookRequestType fromValue(String value) {
        for (RegistrationInlineHookRequestType b : RegistrationInlineHookRequestType.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
