package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies a secret question and answer that&#39;s validated (case insensitive) when a User forgets their password or
 * unlocks their account. The answer property is write-only.
 */
@ApiModel(description = "Specifies a secret question and answer that's validated (case insensitive) when a User forgets their password or unlocks their account. The answer property is write-only.")
@JsonPropertyOrder({ RecoveryQuestionCredential.JSON_PROPERTY_ANSWER,
        RecoveryQuestionCredential.JSON_PROPERTY_QUESTION })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class RecoveryQuestionCredential implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ANSWER = "answer";
    private String answer;

    public static final String JSON_PROPERTY_QUESTION = "question";
    private String question;

    public RecoveryQuestionCredential() {
    }

    public RecoveryQuestionCredential answer(String answer) {

        this.answer = answer;
        return this;
    }

    /**
     * The answer to the recovery question
     *
     * @return answer
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "se7en", value = "The answer to the recovery question")
    @JsonProperty(JSON_PROPERTY_ANSWER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAnswer() {
        return answer;
    }

    @JsonProperty(JSON_PROPERTY_ANSWER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public RecoveryQuestionCredential question(String question) {

        this.question = question;
        return this;
    }

    /**
     * The recovery question
     *
     * @return question
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "what is your favourite movie?", value = "The recovery question")
    @JsonProperty(JSON_PROPERTY_QUESTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getQuestion() {
        return question;
    }

    @JsonProperty(JSON_PROPERTY_QUESTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setQuestion(String question) {
        this.question = question;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RecoveryQuestionCredential recoveryQuestionCredential = (RecoveryQuestionCredential) o;
        return Objects.equals(this.answer, recoveryQuestionCredential.answer)
                && Objects.equals(this.question, recoveryQuestionCredential.question);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(answer, question);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecoveryQuestionCredential {\n");
        sb.append("    answer: ").append(toIndentedString(answer)).append("\n");
        sb.append("    question: ").append(toIndentedString(question)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
