package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ProvisioningAction;
import com.okta.sdk.resource.model.ProvisioningConditions;
import com.okta.sdk.resource.model.ProvisioningGroups;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies the behavior for just-in-time (JIT) provisioning of an IdP User as a new Okta User and their Group
 * memberships
 */
@ApiModel(description = "Specifies the behavior for just-in-time (JIT) provisioning of an IdP User as a new Okta User and their Group memberships")
@JsonPropertyOrder({ Provisioning.JSON_PROPERTY_ACTION, Provisioning.JSON_PROPERTY_CONDITIONS,
        Provisioning.JSON_PROPERTY_GROUPS, Provisioning.JSON_PROPERTY_PROFILE_MASTER })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class Provisioning implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACTION = "action";
    private ProvisioningAction action;

    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private ProvisioningConditions conditions;

    public static final String JSON_PROPERTY_GROUPS = "groups";
    private ProvisioningGroups groups;

    public static final String JSON_PROPERTY_PROFILE_MASTER = "profileMaster";
    private Boolean profileMaster;

    public Provisioning() {
    }

    public Provisioning action(ProvisioningAction action) {

        this.action = action;
        return this;
    }

    /**
     * Get action
     *
     * @return action
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ACTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProvisioningAction getAction() {
        return action;
    }

    @JsonProperty(JSON_PROPERTY_ACTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAction(ProvisioningAction action) {
        this.action = action;
    }

    public Provisioning conditions(ProvisioningConditions conditions) {

        this.conditions = conditions;
        return this;
    }

    /**
     * Get conditions
     *
     * @return conditions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProvisioningConditions getConditions() {
        return conditions;
    }

    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConditions(ProvisioningConditions conditions) {
        this.conditions = conditions;
    }

    public Provisioning groups(ProvisioningGroups groups) {

        this.groups = groups;
        return this;
    }

    /**
     * Get groups
     *
     * @return groups
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProvisioningGroups getGroups() {
        return groups;
    }

    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGroups(ProvisioningGroups groups) {
        this.groups = groups;
    }

    public Provisioning profileMaster(Boolean profileMaster) {

        this.profileMaster = profileMaster;
        return this;
    }

    /**
     * Determines if the IdP should act as a source of truth for User profile attributes
     *
     * @return profileMaster
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Determines if the IdP should act as a source of truth for User profile attributes")
    @JsonProperty(JSON_PROPERTY_PROFILE_MASTER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getProfileMaster() {
        return profileMaster;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE_MASTER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfileMaster(Boolean profileMaster) {
        this.profileMaster = profileMaster;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Provisioning provisioning = (Provisioning) o;
        return Objects.equals(this.action, provisioning.action)
                && Objects.equals(this.conditions, provisioning.conditions)
                && Objects.equals(this.groups, provisioning.groups)
                && Objects.equals(this.profileMaster, provisioning.profileMaster);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(action, conditions, groups, profileMaster);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Provisioning {\n");
        sb.append("    action: ").append(toIndentedString(action)).append("\n");
        sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
        sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
        sb.append("    profileMaster: ").append(toIndentedString(profileMaster)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
