package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SourceLinks;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The parameter is the target of a profile mapping and is a valid [JSON Schema Draft
 * 4](https://datatracker.ietf.org/doc/html/draft-zyp-json-schema-04) document with the following properties. The data
 * type can be an app instance or an Okta object. &gt; **Note:** If the target is Okta and the UserTypes feature
 * isn&#39;t enabled, then the target &#x60;_links&#x60; only has a link to the schema.
 */
@ApiModel(description = "The parameter is the target of a profile mapping and is a valid [JSON Schema Draft 4](https://datatracker.ietf.org/doc/html/draft-zyp-json-schema-04) document with the following properties. The data type can be an app instance or an Okta object.   > **Note:** If the target is Okta and the UserTypes feature isn't enabled, then the target `_links` only has a link to the schema.")
@JsonPropertyOrder({ ProfileMappingTarget.JSON_PROPERTY_ID, ProfileMappingTarget.JSON_PROPERTY_NAME,
        ProfileMappingTarget.JSON_PROPERTY_TYPE, ProfileMappingTarget.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ProfileMappingTarget implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private SourceLinks links;

    public ProfileMappingTarget() {
    }

    /*
     * @JsonCreator public ProfileMappingTarget(
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_NAME) String name,
     *
     * @JsonProperty(JSON_PROPERTY_TYPE) String type ) { this(); this.id = id; this.name = name; this.type = type; }
     */

    /**
     * Unique identifier for the application instance or UserType
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique identifier for the application instance or UserType")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Variable name of the application instance or name of the referenced userType
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Variable name of the application instance or name of the referenced userType")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    /**
     * Type of user referenced in the mapping
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Type of user referenced in the mapping")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    public ProfileMappingTarget links(SourceLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SourceLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(SourceLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProfileMappingTarget profileMappingTarget = (ProfileMappingTarget) o;
        return Objects.equals(this.id, profileMappingTarget.id) && Objects.equals(this.name, profileMappingTarget.name)
                && Objects.equals(this.type, profileMappingTarget.type)
                && Objects.equals(this.links, profileMappingTarget.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, type, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProfileMappingTarget {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
