package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ChangeEnum;
import com.okta.sdk.resource.model.EnabledStatus;
import com.okta.sdk.resource.model.SeedEnum;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Determines whether Okta creates and pushes a password in the app for each assigned user
 */
@ApiModel(description = "Determines whether Okta creates and pushes a password in the app for each assigned user")
@JsonPropertyOrder({ PasswordSettingObject.JSON_PROPERTY_CHANGE, PasswordSettingObject.JSON_PROPERTY_SEED,
        PasswordSettingObject.JSON_PROPERTY_STATUS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class PasswordSettingObject implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CHANGE = "change";
    private ChangeEnum change = ChangeEnum.KEEP_EXISTING;

    public static final String JSON_PROPERTY_SEED = "seed";
    private SeedEnum seed = SeedEnum.RANDOM;

    public static final String JSON_PROPERTY_STATUS = "status";
    private EnabledStatus status;

    public PasswordSettingObject() {
    }

    public PasswordSettingObject change(ChangeEnum change) {

        this.change = change;
        return this;
    }

    /**
     * Get change
     *
     * @return change
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CHANGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ChangeEnum getChange() {
        return change;
    }

    @JsonProperty(JSON_PROPERTY_CHANGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setChange(ChangeEnum change) {
        this.change = change;
    }

    public PasswordSettingObject seed(SeedEnum seed) {

        this.seed = seed;
        return this;
    }

    /**
     * Get seed
     *
     * @return seed
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SEED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SeedEnum getSeed() {
        return seed;
    }

    @JsonProperty(JSON_PROPERTY_SEED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSeed(SeedEnum seed) {
        this.seed = seed;
    }

    public PasswordSettingObject status(EnabledStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EnabledStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(EnabledStatus status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PasswordSettingObject passwordSettingObject = (PasswordSettingObject) o;
        return Objects.equals(this.change, passwordSettingObject.change)
                && Objects.equals(this.seed, passwordSettingObject.seed)
                && Objects.equals(this.status, passwordSettingObject.status);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(change, seed, status);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PasswordSettingObject {\n");
        sb.append("    change: ").append(toIndentedString(change)).append("\n");
        sb.append("    seed: ").append(toIndentedString(seed)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
