package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * PasswordImportRequestDataContextCredential
 */
@JsonPropertyOrder({ PasswordImportRequestDataContextCredential.JSON_PROPERTY_USERNAME,
        PasswordImportRequestDataContextCredential.JSON_PROPERTY_PASSWORD })
@JsonTypeName("PasswordImportRequestData_context_credential")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class PasswordImportRequestDataContextCredential implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;

    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;

    public PasswordImportRequestDataContextCredential() {
    }

    public PasswordImportRequestDataContextCredential username(String username) {

        this.username = username;
        return this;
    }

    /**
     * The &#x60;username&#x60; that the user supplied when attempting to sign in to Okta.
     *
     * @return username
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The `username` that the user supplied when attempting to sign in to Okta.")
    @JsonProperty(JSON_PROPERTY_USERNAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUsername() {
        return username;
    }

    @JsonProperty(JSON_PROPERTY_USERNAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUsername(String username) {
        this.username = username;
    }

    public PasswordImportRequestDataContextCredential password(String password) {

        this.password = password;
        return this;
    }

    /**
     * The &#x60;password&#x60; that the user supplied when attempting to sign in to Okta.
     *
     * @return password
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The `password` that the user supplied when attempting to sign in to Okta.")
    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPassword() {
        return password;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PasswordImportRequestDataContextCredential passwordImportRequestDataContextCredential = (PasswordImportRequestDataContextCredential) o;
        return Objects.equals(this.username, passwordImportRequestDataContextCredential.username)
                && Objects.equals(this.password, passwordImportRequestDataContextCredential.password);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(username, password);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PasswordImportRequestDataContextCredential {\n");
        sb.append("    username: ").append(toIndentedString(username)).append("\n");
        sb.append("    password: ").append(toIndentedString(password)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
