package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Properties governing the User&#39;s session lifetime
 */
@ApiModel(description = "Properties governing the User's session lifetime")
@JsonPropertyOrder({ OktaSignOnPolicyRuleSignonSessionActions.JSON_PROPERTY_MAX_SESSION_IDLE_MINUTES,
        OktaSignOnPolicyRuleSignonSessionActions.JSON_PROPERTY_MAX_SESSION_LIFETIME_MINUTES,
        OktaSignOnPolicyRuleSignonSessionActions.JSON_PROPERTY_USE_PERSISTENT_COOKIE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OktaSignOnPolicyRuleSignonSessionActions implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_MAX_SESSION_IDLE_MINUTES = "maxSessionIdleMinutes";
    private Integer maxSessionIdleMinutes = 120;

    public static final String JSON_PROPERTY_MAX_SESSION_LIFETIME_MINUTES = "maxSessionLifetimeMinutes";
    private Integer maxSessionLifetimeMinutes = 0;

    public static final String JSON_PROPERTY_USE_PERSISTENT_COOKIE = "usePersistentCookie";
    private Boolean usePersistentCookie = false;

    public OktaSignOnPolicyRuleSignonSessionActions() {
    }

    public OktaSignOnPolicyRuleSignonSessionActions maxSessionIdleMinutes(Integer maxSessionIdleMinutes) {

        this.maxSessionIdleMinutes = maxSessionIdleMinutes;
        return this;
    }

    /**
     * Maximum number of minutes that a User session can be idle before the session is ended
     *
     * @return maxSessionIdleMinutes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Maximum number of minutes that a User session can be idle before the session is ended")
    @JsonProperty(JSON_PROPERTY_MAX_SESSION_IDLE_MINUTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getMaxSessionIdleMinutes() {
        return maxSessionIdleMinutes;
    }

    @JsonProperty(JSON_PROPERTY_MAX_SESSION_IDLE_MINUTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMaxSessionIdleMinutes(Integer maxSessionIdleMinutes) {
        this.maxSessionIdleMinutes = maxSessionIdleMinutes;
    }

    public OktaSignOnPolicyRuleSignonSessionActions maxSessionLifetimeMinutes(Integer maxSessionLifetimeMinutes) {

        this.maxSessionLifetimeMinutes = maxSessionLifetimeMinutes;
        return this;
    }

    /**
     * Maximum number of minutes from User sign in that a user&#39;s session is active. Set this to force Users to sign
     * in again after the number of specified minutes. Disable by setting to &#x60;0&#x60;. This property is read-only
     * for the default rule of the default global session policy.
     *
     * @return maxSessionLifetimeMinutes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Maximum number of minutes from User sign in that a user's session is active. Set this to force Users to sign in again after the number of specified minutes. Disable by setting to `0`. This property is read-only for the default rule of the default global session policy.")
    @JsonProperty(JSON_PROPERTY_MAX_SESSION_LIFETIME_MINUTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getMaxSessionLifetimeMinutes() {
        return maxSessionLifetimeMinutes;
    }

    @JsonProperty(JSON_PROPERTY_MAX_SESSION_LIFETIME_MINUTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMaxSessionLifetimeMinutes(Integer maxSessionLifetimeMinutes) {
        this.maxSessionLifetimeMinutes = maxSessionLifetimeMinutes;
    }

    public OktaSignOnPolicyRuleSignonSessionActions usePersistentCookie(Boolean usePersistentCookie) {

        this.usePersistentCookie = usePersistentCookie;
        return this;
    }

    /**
     * If set to &#x60;false&#x60;, user session cookies only last the length of a browser session. If set to
     * &#x60;true&#x60;, user session cookies last across browser sessions. This setting doesn&#39;t impact
     * administrators who can never have persistent session cookies. This property is read-only for the default rule of
     * the default global session policy.
     *
     * @return usePersistentCookie
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "If set to `false`, user session cookies only last the length of a browser session. If set to `true`, user session cookies last across browser sessions. This setting doesn't impact administrators who can never have persistent session cookies. This property is read-only for the default rule of the default global session policy.")
    @JsonProperty(JSON_PROPERTY_USE_PERSISTENT_COOKIE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getUsePersistentCookie() {
        return usePersistentCookie;
    }

    @JsonProperty(JSON_PROPERTY_USE_PERSISTENT_COOKIE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUsePersistentCookie(Boolean usePersistentCookie) {
        this.usePersistentCookie = usePersistentCookie;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OktaSignOnPolicyRuleSignonSessionActions oktaSignOnPolicyRuleSignonSessionActions = (OktaSignOnPolicyRuleSignonSessionActions) o;
        return Objects.equals(this.maxSessionIdleMinutes,
                oktaSignOnPolicyRuleSignonSessionActions.maxSessionIdleMinutes)
                && Objects.equals(this.maxSessionLifetimeMinutes,
                        oktaSignOnPolicyRuleSignonSessionActions.maxSessionLifetimeMinutes)
                && Objects.equals(this.usePersistentCookie,
                        oktaSignOnPolicyRuleSignonSessionActions.usePersistentCookie);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(maxSessionIdleMinutes, maxSessionLifetimeMinutes, usePersistentCookie);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OktaSignOnPolicyRuleSignonSessionActions {\n");
        sb.append("    maxSessionIdleMinutes: ").append(toIndentedString(maxSessionIdleMinutes)).append("\n");
        sb.append("    maxSessionLifetimeMinutes: ").append(toIndentedString(maxSessionLifetimeMinutes)).append("\n");
        sb.append("    usePersistentCookie: ").append(toIndentedString(usePersistentCookie)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
