package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CaepDeviceComplianceChangeEventReasonAdmin;
import com.okta.sdk.resource.model.CaepDeviceComplianceChangeEventReasonUser;
import com.okta.sdk.resource.model.SecurityEventSubject;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The device risk level changed
 */
@ApiModel(description = "The device risk level changed")
@JsonPropertyOrder({ OktaDeviceRiskChangeEvent.JSON_PROPERTY_CURRENT_LEVEL,
        OktaDeviceRiskChangeEvent.JSON_PROPERTY_EVENT_TIMESTAMP,
        OktaDeviceRiskChangeEvent.JSON_PROPERTY_INITIATING_ENTITY,
        OktaDeviceRiskChangeEvent.JSON_PROPERTY_PREVIOUS_LEVEL, OktaDeviceRiskChangeEvent.JSON_PROPERTY_REASON_ADMIN,
        OktaDeviceRiskChangeEvent.JSON_PROPERTY_REASON_USER, OktaDeviceRiskChangeEvent.JSON_PROPERTY_SUBJECT })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OktaDeviceRiskChangeEvent implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Current risk level of the device
     */
    public enum CurrentLevelEnum {
        LOW(String.valueOf("low")),

        MEDIUM(String.valueOf("medium")),

        HIGH(String.valueOf("high")),

        SECURE(String.valueOf("secure")),

        NONE(String.valueOf("none")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        CurrentLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static CurrentLevelEnum fromValue(String value) {
            for (CurrentLevelEnum b : CurrentLevelEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_CURRENT_LEVEL = "current_level";
    private CurrentLevelEnum currentLevel;

    public static final String JSON_PROPERTY_EVENT_TIMESTAMP = "event_timestamp";
    private Long eventTimestamp;

    /**
     * The entity that initiated the event
     */
    public enum InitiatingEntityEnum {
        ADMIN(String.valueOf("admin")),

        USER(String.valueOf("user")),

        POLICY(String.valueOf("policy")),

        SYSTEM(String.valueOf("system")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        InitiatingEntityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static InitiatingEntityEnum fromValue(String value) {
            for (InitiatingEntityEnum b : InitiatingEntityEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_INITIATING_ENTITY = "initiating_entity";
    private InitiatingEntityEnum initiatingEntity;

    /**
     * Previous risk level of the device
     */
    public enum PreviousLevelEnum {
        LOW(String.valueOf("low")),

        MEDIUM(String.valueOf("medium")),

        HIGH(String.valueOf("high")),

        SECURE(String.valueOf("secure")),

        NONE(String.valueOf("none")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        PreviousLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static PreviousLevelEnum fromValue(String value) {
            for (PreviousLevelEnum b : PreviousLevelEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_PREVIOUS_LEVEL = "previous_level";
    private PreviousLevelEnum previousLevel;

    public static final String JSON_PROPERTY_REASON_ADMIN = "reason_admin";
    private CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin;

    public static final String JSON_PROPERTY_REASON_USER = "reason_user";
    private CaepDeviceComplianceChangeEventReasonUser reasonUser;

    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private SecurityEventSubject subject;

    public OktaDeviceRiskChangeEvent() {
    }

    public OktaDeviceRiskChangeEvent currentLevel(CurrentLevelEnum currentLevel) {

        this.currentLevel = currentLevel;
        return this;
    }

    /**
     * Current risk level of the device
     *
     * @return currentLevel
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "low", required = true, value = "Current risk level of the device")
    @JsonProperty(JSON_PROPERTY_CURRENT_LEVEL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public CurrentLevelEnum getCurrentLevel() {
        return currentLevel;
    }

    @JsonProperty(JSON_PROPERTY_CURRENT_LEVEL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setCurrentLevel(CurrentLevelEnum currentLevel) {
        this.currentLevel = currentLevel;
    }

    public OktaDeviceRiskChangeEvent eventTimestamp(Long eventTimestamp) {

        this.eventTimestamp = eventTimestamp;
        return this;
    }

    /**
     * The time of the event (UNIX timestamp)
     *
     * @return eventTimestamp
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "1702448550", required = true, value = "The time of the event (UNIX timestamp)")
    @JsonProperty(JSON_PROPERTY_EVENT_TIMESTAMP)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public Long getEventTimestamp() {
        return eventTimestamp;
    }

    @JsonProperty(JSON_PROPERTY_EVENT_TIMESTAMP)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setEventTimestamp(Long eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    public OktaDeviceRiskChangeEvent initiatingEntity(InitiatingEntityEnum initiatingEntity) {

        this.initiatingEntity = initiatingEntity;
        return this;
    }

    /**
     * The entity that initiated the event
     *
     * @return initiatingEntity
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The entity that initiated the event")
    @JsonProperty(JSON_PROPERTY_INITIATING_ENTITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public InitiatingEntityEnum getInitiatingEntity() {
        return initiatingEntity;
    }

    @JsonProperty(JSON_PROPERTY_INITIATING_ENTITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInitiatingEntity(InitiatingEntityEnum initiatingEntity) {
        this.initiatingEntity = initiatingEntity;
    }

    public OktaDeviceRiskChangeEvent previousLevel(PreviousLevelEnum previousLevel) {

        this.previousLevel = previousLevel;
        return this;
    }

    /**
     * Previous risk level of the device
     *
     * @return previousLevel
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "medium", required = true, value = "Previous risk level of the device")
    @JsonProperty(JSON_PROPERTY_PREVIOUS_LEVEL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public PreviousLevelEnum getPreviousLevel() {
        return previousLevel;
    }

    @JsonProperty(JSON_PROPERTY_PREVIOUS_LEVEL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setPreviousLevel(PreviousLevelEnum previousLevel) {
        this.previousLevel = previousLevel;
    }

    public OktaDeviceRiskChangeEvent reasonAdmin(CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin) {

        this.reasonAdmin = reasonAdmin;
        return this;
    }

    /**
     * Get reasonAdmin
     *
     * @return reasonAdmin
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REASON_ADMIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public CaepDeviceComplianceChangeEventReasonAdmin getReasonAdmin() {
        return reasonAdmin;
    }

    @JsonProperty(JSON_PROPERTY_REASON_ADMIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setReasonAdmin(CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin) {
        this.reasonAdmin = reasonAdmin;
    }

    public OktaDeviceRiskChangeEvent reasonUser(CaepDeviceComplianceChangeEventReasonUser reasonUser) {

        this.reasonUser = reasonUser;
        return this;
    }

    /**
     * Get reasonUser
     *
     * @return reasonUser
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REASON_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public CaepDeviceComplianceChangeEventReasonUser getReasonUser() {
        return reasonUser;
    }

    @JsonProperty(JSON_PROPERTY_REASON_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setReasonUser(CaepDeviceComplianceChangeEventReasonUser reasonUser) {
        this.reasonUser = reasonUser;
    }

    public OktaDeviceRiskChangeEvent subject(SecurityEventSubject subject) {

        this.subject = subject;
        return this;
    }

    /**
     * Get subject
     *
     * @return subject
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_SUBJECT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public SecurityEventSubject getSubject() {
        return subject;
    }

    @JsonProperty(JSON_PROPERTY_SUBJECT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setSubject(SecurityEventSubject subject) {
        this.subject = subject;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OktaDeviceRiskChangeEvent oktaDeviceRiskChangeEvent = (OktaDeviceRiskChangeEvent) o;
        return Objects.equals(this.currentLevel, oktaDeviceRiskChangeEvent.currentLevel)
                && Objects.equals(this.eventTimestamp, oktaDeviceRiskChangeEvent.eventTimestamp)
                && Objects.equals(this.initiatingEntity, oktaDeviceRiskChangeEvent.initiatingEntity)
                && Objects.equals(this.previousLevel, oktaDeviceRiskChangeEvent.previousLevel)
                && Objects.equals(this.reasonAdmin, oktaDeviceRiskChangeEvent.reasonAdmin)
                && Objects.equals(this.reasonUser, oktaDeviceRiskChangeEvent.reasonUser)
                && Objects.equals(this.subject, oktaDeviceRiskChangeEvent.subject);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(currentLevel, eventTimestamp, initiatingEntity, previousLevel, reasonAdmin, reasonUser,
                subject);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OktaDeviceRiskChangeEvent {\n");
        sb.append("    currentLevel: ").append(toIndentedString(currentLevel)).append("\n");
        sb.append("    eventTimestamp: ").append(toIndentedString(eventTimestamp)).append("\n");
        sb.append("    initiatingEntity: ").append(toIndentedString(initiatingEntity)).append("\n");
        sb.append("    previousLevel: ").append(toIndentedString(previousLevel)).append("\n");
        sb.append("    reasonAdmin: ").append(toIndentedString(reasonAdmin)).append("\n");
        sb.append("    reasonUser: ").append(toIndentedString(reasonUser)).append("\n");
        sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
