package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Office365 app instance properties
 */
@ApiModel(description = "Office365 app instance properties")
@JsonPropertyOrder({ Office365ApplicationSettingsApplication.JSON_PROPERTY_DOMAIN,
        Office365ApplicationSettingsApplication.JSON_PROPERTY_MSFT_TENANT })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class Office365ApplicationSettingsApplication implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;

    public static final String JSON_PROPERTY_MSFT_TENANT = "msftTenant";
    private String msftTenant;

    public Office365ApplicationSettingsApplication() {
    }

    public Office365ApplicationSettingsApplication domain(String domain) {

        this.domain = domain;
        return this;
    }

    /**
     * The domain for your Office 365 account
     *
     * @return domain
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The domain for your Office 365 account")
    @JsonProperty(JSON_PROPERTY_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getDomain() {
        return domain;
    }

    @JsonProperty(JSON_PROPERTY_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Office365ApplicationSettingsApplication msftTenant(String msftTenant) {

        this.msftTenant = msftTenant;
        return this;
    }

    /**
     * Microsoft tenant name
     *
     * @return msftTenant
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Microsoft tenant name")
    @JsonProperty(JSON_PROPERTY_MSFT_TENANT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getMsftTenant() {
        return msftTenant;
    }

    @JsonProperty(JSON_PROPERTY_MSFT_TENANT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setMsftTenant(String msftTenant) {
        this.msftTenant = msftTenant;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Office365ApplicationSettingsApplication office365ApplicationSettingsApplication = (Office365ApplicationSettingsApplication) o;
        return Objects.equals(this.domain, office365ApplicationSettingsApplication.domain)
                && Objects.equals(this.msftTenant, office365ApplicationSettingsApplication.msftTenant);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(domain, msftTenant);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Office365ApplicationSettingsApplication {\n");
        sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
        sb.append("    msftTenant: ").append(toIndentedString(msftTenant)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
