package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Specifies whether the Claim is an Okta Expression Language (EL) expression (&#x60;EXPRESSION&#x60;), a set of groups
 * (&#x60;GROUPS&#x60;), or a system claim (&#x60;SYSTEM&#x60;)
 */
public enum OAuth2ClaimValueType {

    EXPRESSION("EXPRESSION"),

    GROUPS("GROUPS"),

    SYSTEM("SYSTEM"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    OAuth2ClaimValueType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static OAuth2ClaimValueType fromValue(String value) {
        for (OAuth2ClaimValueType b : OAuth2ClaimValueType.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
