package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * NetworkZoneLocation
 */
@JsonPropertyOrder({ NetworkZoneLocation.JSON_PROPERTY_COUNTRY, NetworkZoneLocation.JSON_PROPERTY_REGION })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class NetworkZoneLocation implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_COUNTRY = "country";
    private String country;

    public static final String JSON_PROPERTY_REGION = "region";
    private String region;

    public NetworkZoneLocation() {
    }

    public NetworkZoneLocation country(String country) {

        this.country = country;
        return this;
    }

    /**
     * The two-character ISO-3166-1 country code. Don&#39;t use continent codes since they are treated as generic codes
     * for undesignated countries. &lt;br&gt;For example: &#x60;US&#x60;
     *
     * @return country
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The two-character ISO-3166-1 country code. Don't use continent codes since they are treated as generic codes for undesignated countries. <br>For example: `US`")
    @JsonProperty(JSON_PROPERTY_COUNTRY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCountry() {
        return country;
    }

    @JsonProperty(JSON_PROPERTY_COUNTRY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCountry(String country) {
        this.country = country;
    }

    public NetworkZoneLocation region(String region) {

        this.region = region;
        return this;
    }

    /**
     * (Optional) The ISO-3166-2 region code appended to the country code (&#x60;countryCode-regionCode&#x60;), or
     * &#x60;null&#x60; if empty. Don&#39;t use continent codes since they are treated as generic codes for undesignated
     * regions. &lt;br&gt;For example: &#x60;CA&#x60; (for &#x60;US-CA&#x60; country and region code)
     *
     * @return region
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "(Optional) The ISO-3166-2 region code appended to the country code (`countryCode-regionCode`), or `null` if empty. Don't use continent codes since they are treated as generic codes for undesignated regions. <br>For example: `CA` (for `US-CA` country and region code)")
    @JsonProperty(JSON_PROPERTY_REGION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRegion() {
        return region;
    }

    @JsonProperty(JSON_PROPERTY_REGION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRegion(String region) {
        this.region = region;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        NetworkZoneLocation networkZoneLocation = (NetworkZoneLocation) o;
        return Objects.equals(this.country, networkZoneLocation.country)
                && Objects.equals(this.region, networkZoneLocation.region);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(country, region);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NetworkZoneLocation {\n");
        sb.append("    country: ").append(toIndentedString(country)).append("\n");
        sb.append("    region: ").append(toIndentedString(region)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
