package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksSelfAndLifecycle;
import com.okta.sdk.resource.model.NetworkZoneStatus;
import com.okta.sdk.resource.model.NetworkZoneType;
import com.okta.sdk.resource.model.NetworkZoneUsage;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * NetworkZone
 */
@JsonPropertyOrder({ NetworkZone.JSON_PROPERTY_CREATED, NetworkZone.JSON_PROPERTY_ID,
        NetworkZone.JSON_PROPERTY_LAST_UPDATED, NetworkZone.JSON_PROPERTY_NAME, NetworkZone.JSON_PROPERTY_STATUS,
        NetworkZone.JSON_PROPERTY_SYSTEM, NetworkZone.JSON_PROPERTY_TYPE, NetworkZone.JSON_PROPERTY_USAGE,
        NetworkZone.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", visible = true, defaultImpl = NetworkZone.class)
@JsonSubTypes({ @JsonSubTypes.Type(value = DynamicNetworkZone.class, name = "DYNAMIC"),
        @JsonSubTypes.Type(value = EnhancedDynamicNetworkZone.class, name = "DYNAMIC_V2"),
        @JsonSubTypes.Type(value = IPNetworkZone.class, name = "IP"), })

public class NetworkZone implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_STATUS = "status";
    private NetworkZoneStatus status;

    public static final String JSON_PROPERTY_SYSTEM = "system";
    private Boolean system;

    public static final String JSON_PROPERTY_TYPE = "type";
    protected NetworkZoneType type;

    public static final String JSON_PROPERTY_USAGE = "usage";
    private NetworkZoneUsage usage;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelfAndLifecycle links;

    public NetworkZone() {
    }

    /*
     * @JsonCreator public NetworkZone(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_SYSTEM) Boolean system ) { this(); this.created = created; this.id = id;
     * this.lastUpdated = lastUpdated; this.system = system; }
     */

    /**
     * Timestamp when the object was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the object was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * Unique identifier for the Network Zone
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique identifier for the Network Zone")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Timestamp when the object was last modified
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the object was last modified")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public NetworkZone name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Unique name for this Network Zone
     *
     * @return name
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Unique name for this Network Zone")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public NetworkZone status(NetworkZoneStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public NetworkZoneStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(NetworkZoneStatus status) {
        this.status = status;
    }

    /**
     * Indicates a system Network Zone: * &#x60;true&#x60; for system Network Zones * &#x60;false&#x60; for custom
     * Network Zones The Okta org provides the following default system Network Zones: * &#x60;LegacyIpZone&#x60; *
     * &#x60;BlockedIpZone&#x60; * &#x60;DefaultEnhancedDynamicZone&#x60; Admins can modify the name of the default
     * system Network Zone and add up to 5000 gateway or proxy IP entries.
     *
     * @return system
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates a system Network Zone: * `true` for system Network Zones * `false` for custom Network Zones  The Okta org provides the following default system Network Zones: * `LegacyIpZone` * `BlockedIpZone` * `DefaultEnhancedDynamicZone`  Admins can modify the name of the default system Network Zone and add up to 5000 gateway or proxy IP entries. ")
    @JsonProperty(JSON_PROPERTY_SYSTEM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSystem() {
        return system;
    }

    public NetworkZone type(NetworkZoneType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public NetworkZoneType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setType(NetworkZoneType type) {
        this.type = type;
    }

    public NetworkZone usage(NetworkZoneUsage usage) {

        this.usage = usage;
        return this;
    }

    /**
     * Get usage
     *
     * @return usage
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USAGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public NetworkZoneUsage getUsage() {
        return usage;
    }

    @JsonProperty(JSON_PROPERTY_USAGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUsage(NetworkZoneUsage usage) {
        this.usage = usage;
    }

    public NetworkZone links(LinksSelfAndLifecycle links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelfAndLifecycle getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelfAndLifecycle links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        NetworkZone networkZone = (NetworkZone) o;
        return Objects.equals(this.created, networkZone.created) && Objects.equals(this.id, networkZone.id)
                && Objects.equals(this.lastUpdated, networkZone.lastUpdated)
                && Objects.equals(this.name, networkZone.name) && Objects.equals(this.status, networkZone.status)
                && Objects.equals(this.system, networkZone.system) && Objects.equals(this.type, networkZone.type)
                && Objects.equals(this.usage, networkZone.usage) && Objects.equals(this.links, networkZone.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, id, lastUpdated, name, status, system, type, usage, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NetworkZone {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    system: ").append(toIndentedString(system)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    usage: ").append(toIndentedString(usage)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
