package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LogDiskEncryptionType;
import com.okta.sdk.resource.model.LogScreenLockType;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The entity that describes a device enrolled with passwordless authentication using Okta Verify.
 */
@ApiModel(description = "The entity that describes a device enrolled with passwordless authentication using Okta Verify.")
@JsonPropertyOrder({ LogDevice.JSON_PROPERTY_DEVICE_INTEGRATOR, LogDevice.JSON_PROPERTY_DISK_ENCRYPTION_TYPE,
        LogDevice.JSON_PROPERTY_ID, LogDevice.JSON_PROPERTY_JAILBREAK, LogDevice.JSON_PROPERTY_MANAGED,
        LogDevice.JSON_PROPERTY_NAME, LogDevice.JSON_PROPERTY_OS_PLATFORM, LogDevice.JSON_PROPERTY_OS_VERSION,
        LogDevice.JSON_PROPERTY_REGISTERED, LogDevice.JSON_PROPERTY_SCREEN_LOCK_TYPE,
        LogDevice.JSON_PROPERTY_SECURE_HARDWARE_PRESENT })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class LogDevice implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DEVICE_INTEGRATOR = "device_integrator";
    private Object deviceIntegrator;

    public static final String JSON_PROPERTY_DISK_ENCRYPTION_TYPE = "disk_encryption_type";
    private LogDiskEncryptionType diskEncryptionType;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_JAILBREAK = "jailbreak";
    private Boolean jailbreak;

    public static final String JSON_PROPERTY_MANAGED = "managed";
    private Boolean managed;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_OS_PLATFORM = "os_platform";
    private String osPlatform;

    public static final String JSON_PROPERTY_OS_VERSION = "os_version";
    private String osVersion;

    public static final String JSON_PROPERTY_REGISTERED = "registered";
    private Boolean registered;

    public static final String JSON_PROPERTY_SCREEN_LOCK_TYPE = "screen_lock_type";
    private LogScreenLockType screenLockType;

    public static final String JSON_PROPERTY_SECURE_HARDWARE_PRESENT = "secure_hardware_present";
    private Boolean secureHardwarePresent;

    public LogDevice() {
    }

    /*
     * @JsonCreator public LogDevice(
     *
     * @JsonProperty(JSON_PROPERTY_DEVICE_INTEGRATOR) Object deviceIntegrator,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_JAILBREAK) Boolean jailbreak,
     *
     * @JsonProperty(JSON_PROPERTY_MANAGED) Boolean managed,
     *
     * @JsonProperty(JSON_PROPERTY_NAME) String name,
     *
     * @JsonProperty(JSON_PROPERTY_OS_PLATFORM) String osPlatform,
     *
     * @JsonProperty(JSON_PROPERTY_OS_VERSION) String osVersion,
     *
     * @JsonProperty(JSON_PROPERTY_REGISTERED) Boolean registered,
     *
     * @JsonProperty(JSON_PROPERTY_SECURE_HARDWARE_PRESENT) Boolean secureHardwarePresent ) { this();
     * this.deviceIntegrator = deviceIntegrator; this.id = id; this.jailbreak = jailbreak; this.managed = managed;
     * this.name = name; this.osPlatform = osPlatform; this.osVersion = osVersion; this.registered = registered;
     * this.secureHardwarePresent = secureHardwarePresent; }
     */

    /**
     * The integration platform or software used with the device
     *
     * @return deviceIntegrator
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The integration platform or software used with the device")
    @JsonProperty(JSON_PROPERTY_DEVICE_INTEGRATOR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Object getDeviceIntegrator() {
        return deviceIntegrator;
    }

    public LogDevice diskEncryptionType(LogDiskEncryptionType diskEncryptionType) {

        this.diskEncryptionType = diskEncryptionType;
        return this;
    }

    /**
     * Get diskEncryptionType
     *
     * @return diskEncryptionType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DISK_ENCRYPTION_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LogDiskEncryptionType getDiskEncryptionType() {
        return diskEncryptionType;
    }

    @JsonProperty(JSON_PROPERTY_DISK_ENCRYPTION_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDiskEncryptionType(LogDiskEncryptionType diskEncryptionType) {
        this.diskEncryptionType = diskEncryptionType;
    }

    /**
     * ID of the device
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID of the device")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * If the device has removed software restrictions
     *
     * @return jailbreak
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "If the device has removed software restrictions")
    @JsonProperty(JSON_PROPERTY_JAILBREAK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getJailbreak() {
        return jailbreak;
    }

    /**
     * Indicates if the device is configured for device management and is registered with Okta
     *
     * @return managed
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if the device is configured for device management and is registered with Okta")
    @JsonProperty(JSON_PROPERTY_MANAGED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getManaged() {
        return managed;
    }

    /**
     * Get name
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    /**
     * Get osPlatform
     *
     * @return osPlatform
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_OS_PLATFORM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOsPlatform() {
        return osPlatform;
    }

    /**
     * Get osVersion
     *
     * @return osVersion
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_OS_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOsVersion() {
        return osVersion;
    }

    /**
     * Indicates if the device is registered with an Okta org and is bound to an Okta Verify instance on the device
     *
     * @return registered
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if the device is registered with an Okta org and is bound to an Okta Verify instance on the device")
    @JsonProperty(JSON_PROPERTY_REGISTERED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getRegistered() {
        return registered;
    }

    public LogDevice screenLockType(LogScreenLockType screenLockType) {

        this.screenLockType = screenLockType;
        return this;
    }

    /**
     * Get screenLockType
     *
     * @return screenLockType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SCREEN_LOCK_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LogScreenLockType getScreenLockType() {
        return screenLockType;
    }

    @JsonProperty(JSON_PROPERTY_SCREEN_LOCK_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScreenLockType(LogScreenLockType screenLockType) {
        this.screenLockType = screenLockType;
    }

    /**
     * The availability of hardware security on the device
     *
     * @return secureHardwarePresent
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The availability of hardware security on the device")
    @JsonProperty(JSON_PROPERTY_SECURE_HARDWARE_PRESENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSecureHardwarePresent() {
        return secureHardwarePresent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogDevice logDevice = (LogDevice) o;
        return Objects.equals(this.deviceIntegrator, logDevice.deviceIntegrator)
                && Objects.equals(this.diskEncryptionType, logDevice.diskEncryptionType)
                && Objects.equals(this.id, logDevice.id) && Objects.equals(this.jailbreak, logDevice.jailbreak)
                && Objects.equals(this.managed, logDevice.managed) && Objects.equals(this.name, logDevice.name)
                && Objects.equals(this.osPlatform, logDevice.osPlatform)
                && Objects.equals(this.osVersion, logDevice.osVersion)
                && Objects.equals(this.registered, logDevice.registered)
                && Objects.equals(this.screenLockType, logDevice.screenLockType)
                && Objects.equals(this.secureHardwarePresent, logDevice.secureHardwarePresent);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(deviceIntegrator, diskEncryptionType, id, jailbreak, managed, name, osPlatform, osVersion,
                registered, screenLockType, secureHardwarePresent);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogDevice {\n");
        sb.append("    deviceIntegrator: ").append(toIndentedString(deviceIntegrator)).append("\n");
        sb.append("    diskEncryptionType: ").append(toIndentedString(diskEncryptionType)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    jailbreak: ").append(toIndentedString(jailbreak)).append("\n");
        sb.append("    managed: ").append(toIndentedString(managed)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    osPlatform: ").append(toIndentedString(osPlatform)).append("\n");
        sb.append("    osVersion: ").append(toIndentedString(osVersion)).append("\n");
        sb.append("    registered: ").append(toIndentedString(registered)).append("\n");
        sb.append("    screenLockType: ").append(toIndentedString(screenLockType)).append("\n");
        sb.append("    secureHardwarePresent: ").append(toIndentedString(secureHardwarePresent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
