package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksSelfAndLifecycle;
import com.okta.sdk.resource.model.NetworkZone;
import com.okta.sdk.resource.model.NetworkZoneAddress;
import com.okta.sdk.resource.model.NetworkZoneStatus;
import com.okta.sdk.resource.model.NetworkZoneType;
import com.okta.sdk.resource.model.NetworkZoneUsage;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * IPNetworkZone
 */
@JsonPropertyOrder({ IPNetworkZone.JSON_PROPERTY_GATEWAYS, IPNetworkZone.JSON_PROPERTY_PROXIES })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", visible = true, defaultImpl = IPNetworkZone.class)

public class IPNetworkZone extends NetworkZone implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_GATEWAYS = "gateways";
    private List<NetworkZoneAddress> gateways = null;

    public static final String JSON_PROPERTY_PROXIES = "proxies";
    private JsonNullable<List<NetworkZoneAddress>> proxies = JsonNullable.<List<NetworkZoneAddress>> undefined();

    public IPNetworkZone() {
    }

    /*
     * @JsonCreator public IPNetworkZone(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_SYSTEM) Boolean system ) { this(); this.created = created; this.id = id;
     * this.lastUpdated = lastUpdated; this.system = system; }
     */

    public IPNetworkZone gateways(List<NetworkZoneAddress> gateways) {

        this.gateways = gateways;
        return this;
    }

    public IPNetworkZone addgatewaysItem(NetworkZoneAddress gatewaysItem) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<>();
        }
        this.gateways.add(gatewaysItem);
        return this;
    }

    /**
     * The IP addresses (range or CIDR form) for an IP Network Zone. The maximum array length is 150 entries for
     * admin-created IP zones, 1000 entries for IP blocklist zones, and 5000 entries for the default system IP Zone.
     *
     * @return gateways
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The IP addresses (range or CIDR form) for an IP Network Zone. The maximum array length is 150 entries for admin-created IP zones, 1000 entries for IP blocklist zones, and 5000 entries for the default system IP Zone.")
    @JsonProperty(JSON_PROPERTY_GATEWAYS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<NetworkZoneAddress> getGateways() {
        return gateways;
    }

    @JsonProperty(JSON_PROPERTY_GATEWAYS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGateways(List<NetworkZoneAddress> gateways) {
        this.gateways = gateways;
    }

    public IPNetworkZone proxies(List<NetworkZoneAddress> proxies) {
        this.proxies = JsonNullable.<List<NetworkZoneAddress>> of(proxies);

        return this;
    }

    public IPNetworkZone addproxiesItem(NetworkZoneAddress proxiesItem) {
        if (this.proxies == null || !this.proxies.isPresent()) {
            this.proxies = JsonNullable.<List<NetworkZoneAddress>> of(new ArrayList<>());
        }
        try {
            this.proxies.get().add(proxiesItem);
        } catch (java.util.NoSuchElementException e) {
            // this can never happen, as we make sure above that the value is present
        }
        return this;
    }

    /**
     * The IP addresses (range or CIDR form) that are allowed to forward a request from gateway addresses for an IP
     * Network Zone. These proxies are automatically trusted by Threat Insights and used to identify the client IP of a
     * request. The maximum array length is 150 entries for admin-created zones and 5000 entries for the default system
     * IP Zone.
     *
     * @return proxies
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The IP addresses (range or CIDR form) that are allowed to forward a request from gateway addresses for an IP Network Zone. These proxies are automatically trusted by Threat Insights and used to identify the client IP of a request. The maximum array length is 150 entries for admin-created zones and 5000 entries for the default system IP Zone.")
    @JsonIgnore

    public List<NetworkZoneAddress> getProxies() {
        return proxies.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_PROXIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<List<NetworkZoneAddress>> getProxies_JsonNullable() {
        return proxies;
    }

    @JsonProperty(JSON_PROPERTY_PROXIES)
    public void setProxies_JsonNullable(JsonNullable<List<NetworkZoneAddress>> proxies) {
        this.proxies = proxies;
    }

    public void setProxies(List<NetworkZoneAddress> proxies) {
        this.proxies = JsonNullable.<List<NetworkZoneAddress>> of(proxies);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IPNetworkZone ipNetworkZone = (IPNetworkZone) o;
        return Objects.equals(this.gateways, ipNetworkZone.gateways)
                && equalsNullable(this.proxies, ipNetworkZone.proxies);
        // && super.equals(o);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(gateways, hashCodeNullable(proxies), super.hashCode());
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IPNetworkZone {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    gateways: ").append(toIndentedString(gateways)).append("\n");
        sb.append("    proxies: ").append(toIndentedString(proxies)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
