package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.GroupLinks;
import com.okta.sdk.resource.model.GroupProfile;
import com.okta.sdk.resource.model.GroupType;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Group
 */
@JsonPropertyOrder({ Group.JSON_PROPERTY_CREATED, Group.JSON_PROPERTY_ID, Group.JSON_PROPERTY_LAST_MEMBERSHIP_UPDATED,
        Group.JSON_PROPERTY_LAST_UPDATED, Group.JSON_PROPERTY_OBJECT_CLASS, Group.JSON_PROPERTY_PROFILE,
        Group.JSON_PROPERTY_TYPE, Group.JSON_PROPERTY_EMBEDDED, Group.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class Group implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_MEMBERSHIP_UPDATED = "lastMembershipUpdated";
    private OffsetDateTime lastMembershipUpdated;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_OBJECT_CLASS = "objectClass";
    private List<String> objectClass = null;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private GroupProfile profile;

    public static final String JSON_PROPERTY_TYPE = "type";
    private GroupType type;

    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private Map<String, Object> embedded = null;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private GroupLinks links;

    public Group() {
    }

    /*
     * @JsonCreator public Group(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_MEMBERSHIP_UPDATED) OffsetDateTime lastMembershipUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_OBJECT_CLASS) List<String> objectClass,
     *
     * @JsonProperty(JSON_PROPERTY_EMBEDDED) Map<String, Object> embedded ) { this(); this.created = created; this.id =
     * id; this.lastMembershipUpdated = lastMembershipUpdated; this.lastUpdated = lastUpdated; this.objectClass =
     * objectClass; this.embedded = embedded; }
     */

    /**
     * Timestamp when the Group was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the Group was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * Unique ID for the Group
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "0gabcd1234", value = "Unique ID for the Group")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Timestamp when the Groups memberships were last updated
     *
     * @return lastMembershipUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the Groups memberships were last updated")
    @JsonProperty(JSON_PROPERTY_LAST_MEMBERSHIP_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastMembershipUpdated() {
        return lastMembershipUpdated;
    }

    /**
     * Timestamp when the Group&#39;s Profile was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the Group's Profile was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    /**
     * Determines the Group&#39;s &#x60;profile&#x60;
     *
     * @return objectClass
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Determines the Group's `profile`")
    @JsonProperty(JSON_PROPERTY_OBJECT_CLASS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getObjectClass() {
        return objectClass;
    }

    public Group profile(GroupProfile profile) {

        this.profile = profile;
        return this;
    }

    /**
     * Get profile
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GroupProfile getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(GroupProfile profile) {
        this.profile = profile;
    }

    public Group type(GroupType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GroupType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(GroupType type) {
        this.type = type;
    }

    /**
     * Embedded resources related to the Group
     *
     * @return embedded
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Embedded resources related to the Group")
    @JsonProperty(JSON_PROPERTY_EMBEDDED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getEmbedded() {
        return embedded;
    }

    public Group links(GroupLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GroupLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(GroupLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Group group = (Group) o;
        return Objects.equals(this.created, group.created) && Objects.equals(this.id, group.id)
                && Objects.equals(this.lastMembershipUpdated, group.lastMembershipUpdated)
                && Objects.equals(this.lastUpdated, group.lastUpdated)
                && Objects.equals(this.objectClass, group.objectClass) && Objects.equals(this.profile, group.profile)
                && Objects.equals(this.type, group.type) && Objects.equals(this.embedded, group.embedded)
                && Objects.equals(this.links, group.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, id, lastMembershipUpdated, lastUpdated, objectClass, profile, type, embedded,
                links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Group {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastMembershipUpdated: ").append(toIndentedString(lastMembershipUpdated)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    objectClass: ").append(toIndentedString(objectClass)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
