package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.IAMBundleEntitlement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * GovernanceBundleUpdateRequest
 */
@JsonPropertyOrder({ GovernanceBundleUpdateRequest.JSON_PROPERTY_DESCRIPTION,
        GovernanceBundleUpdateRequest.JSON_PROPERTY_ENTITLEMENTS, GovernanceBundleUpdateRequest.JSON_PROPERTY_NAME })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class GovernanceBundleUpdateRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_ENTITLEMENTS = "entitlements";
    private List<IAMBundleEntitlement> entitlements = null;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public GovernanceBundleUpdateRequest() {
    }

    public GovernanceBundleUpdateRequest description(String description) {

        this.description = description;
        return this;
    }

    /**
     * Get description
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public GovernanceBundleUpdateRequest entitlements(List<IAMBundleEntitlement> entitlements) {

        this.entitlements = entitlements;
        return this;
    }

    public GovernanceBundleUpdateRequest addentitlementsItem(IAMBundleEntitlement entitlementsItem) {
        if (this.entitlements == null) {
            this.entitlements = new ArrayList<>();
        }
        this.entitlements.add(entitlementsItem);
        return this;
    }

    /**
     * Get entitlements
     *
     * @return entitlements
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ENTITLEMENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<IAMBundleEntitlement> getEntitlements() {
        return entitlements;
    }

    @JsonProperty(JSON_PROPERTY_ENTITLEMENTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEntitlements(List<IAMBundleEntitlement> entitlements) {
        this.entitlements = entitlements;
    }

    public GovernanceBundleUpdateRequest name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Get name
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GovernanceBundleUpdateRequest governanceBundleUpdateRequest = (GovernanceBundleUpdateRequest) o;
        return Objects.equals(this.description, governanceBundleUpdateRequest.description)
                && Objects.equals(this.entitlements, governanceBundleUpdateRequest.entitlements)
                && Objects.equals(this.name, governanceBundleUpdateRequest.name);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(description, entitlements, name);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GovernanceBundleUpdateRequest {\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    entitlements: ").append(toIndentedString(entitlements)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
