package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.EnabledStatus;
import com.okta.sdk.resource.model.FeatureLinks;
import com.okta.sdk.resource.model.FeatureStage;
import com.okta.sdk.resource.model.FeatureType;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies feature release cycle information
 */
@ApiModel(description = "Specifies feature release cycle information")
@JsonPropertyOrder({ Feature.JSON_PROPERTY_DESCRIPTION, Feature.JSON_PROPERTY_ID, Feature.JSON_PROPERTY_NAME,
        Feature.JSON_PROPERTY_STAGE, Feature.JSON_PROPERTY_STATUS, Feature.JSON_PROPERTY_TYPE,
        Feature.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class Feature implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_STAGE = "stage";
    private FeatureStage stage;

    public static final String JSON_PROPERTY_STATUS = "status";
    private EnabledStatus status;

    public static final String JSON_PROPERTY_TYPE = "type";
    private FeatureType type;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private FeatureLinks links;

    public Feature() {
    }

    /*
     * @JsonCreator public Feature(
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id ) { this(); this.id = id; }
     */

    public Feature description(String description) {

        this.description = description;
        return this;
    }

    /**
     * Brief description of the feature and what it provides
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Brief description of the feature and what it provides")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Unique identifier for this feature
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique identifier for this feature")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    public Feature name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Name of the feature
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the feature")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public Feature stage(FeatureStage stage) {

        this.stage = stage;
        return this;
    }

    /**
     * Get stage
     *
     * @return stage
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STAGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FeatureStage getStage() {
        return stage;
    }

    @JsonProperty(JSON_PROPERTY_STAGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStage(FeatureStage stage) {
        this.stage = stage;
    }

    public Feature status(EnabledStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EnabledStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(EnabledStatus status) {
        this.status = status;
    }

    public Feature type(FeatureType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FeatureType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(FeatureType type) {
        this.type = type;
    }

    public Feature links(FeatureLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FeatureLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(FeatureLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Feature feature = (Feature) o;
        return Objects.equals(this.description, feature.description) && Objects.equals(this.id, feature.id)
                && Objects.equals(this.name, feature.name) && Objects.equals(this.stage, feature.stage)
                && Objects.equals(this.status, feature.status) && Objects.equals(this.type, feature.type)
                && Objects.equals(this.links, feature.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(description, id, name, stage, status, type, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Feature {\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    stage: ").append(toIndentedString(stage)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
